#' Attachment-related mother-child interaction dataset
#'
#' During an attachment study, a  mother and her child (middle childhood; age between eight and 12)
#' were videotaped while working on a three-minutes stressful puzzle task.
#' The interaction was coded in two-second intervals for the presence and absence
#' of positive, negative, and task related behavior. The dataset contains
#' seven variables and 90 time intervals.
#'
#' @name AttachmentData
#' @author Adinda Dujardin & Guy Bosmans \email{guy.bosmans@@kuleuven.be}
#' @format A data frame with 90 rows and 7 variables:
#' \describe{
#'   \item{Mpos}{mother's positive behavior}
#'   \item{Mneg}{mother's negative behavior}
#'   \item{MAlone}{mother is working on the task alone}
#'   \item{Togth}{mother and child are working on the task together}
#'   \item{Cpos}{child's positive behavior}
#'   \item{Cneg}{child's negative behavior}
#'   \item{CAlone}{child is working on the task alone}
#'
#' }
#'
#' 
#' @references Bodner, N., Bosmans, G., Sannen, J., Verhees, M., & Ceulemans, E. (2019). Unraveling middle childhood attachment-related behavior sequences using a micro-coding approach. PLOS ONE, 14(10), e0224372. https://doi.org/10.1371/journal.pone.0224372
#'
"AttachmentData"
