#' Depression symptom dataset
#'
#' In this depression symptoms data, a patient reported for each week on the presence
#' and absence of eight depression symptoms. The dataset contains the reports of the
#' eight variables for 145 subsequent weeks.
#'
#'
#' @name SymptomData
#' @author Bettina Hosenfeld & Peter de Jonge \email{peter.de.jonge@@rug.nl}
#' @format A data frame with 145 rows and 8 variables:
#' \describe{
#'   \item{Core}{core depression symptoms including depressed mood and/or diminished interest}
#'   \item{Energy}{lack of energy}
#'   \item{Eat}{eating problems and weight loss or gain}
#'   \item{Sleep}{sleeping problems including hyposomnia or hypersomnia}
#'   \item{Motor}{psychomotor problems}
#'   \item{Guilt}{feelings of guilt}
#'   \item{Cogn}{cognitive problems}
#'   \item{Death}{preoccupation with death}
#'
#' }
#'
#' @references {Hosenfeld, B., Bos, E. H., Wardenaar, K. J., Conradi, H. J., van der Maas, H. L. J., Visser, I., & de Jonge, P. (2015). Major depressive disorder as a nonlinear dynamic system: Bimodality in the frequency distribution of depressive symptoms over time. BMC Psychiatry, 15(1), 222. https://doi.org/10.1186/s12888-015-0596-5}
#' @references {Bodner, N., Bringmann, L., Tuerlinckx, F., De Jonge, P., & Ceulemans, E. (in press). ConNEcT: A novel network approach for investigating the co-occurrence of binary psychopathological symptoms over time. Psychometrika. https://doi.org/10.1007/s11336-021-09765-2}
"SymptomData"
