% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conNEcT.R
\name{conNEcT}
\alias{conNEcT}
\title{Calculate the link strength between multiple behaviors and return them as a matrix (optionally discarting all non-significant links)}
\usage{
conNEcT(
  data,
  lag = 0,
  conFun,
  test = FALSE,
  typeOfTest = "permut",
  adCor = TRUE,
  nBlox = 10,
  nReps = 100,
  signLev = 0.05
)
}
\arguments{
\item{data}{Binary time-points-by-variable matrix}

\item{lag}{Non-negative integer indicating how many time points the second variable is lagged (default 0)}

\item{conFun}{Contingency measure function (calculating the contingency value between two binary vectors).
Built in: funPropAgree, funClassJacc, funKappa, funCorrJacc, funOdds, funLogOdds, funPhiCC}

\item{test}{Logic indicationg whether a significance test is executed (TRUE) or not (FALSE;default)}

\item{typeOfTest}{String indicating whether a model-based ('model') or a permutation-based ('permut'; default) data generation approach is used.}

\item{adCor}{Logic indicating the auto-dependence correction should be applied (TRUE; default) or not (FALSE)}

\item{nBlox}{Number indicating the number of segments (default  10).
Necessary for permutation-based test, accounting for auto-dependence
(typeOfTest='permut'; adCor=TRUE)}

\item{nReps}{Number of replicates/samples that is used to generate the test distribution}

\item{signLev}{Significance level of the test (default 0.05)}
}
\value{
A conNEcT-object including

\code{allLinks} Matrix of pairwise calculated contingency measures

\code{signLinks}Matrix of pairwise calculated contingency measures containing only significant links
(others are set to 0)

\code{pValue} P-values for the one-sided upper significance test

\code{para} Parameter settings containing
\code{lag}, \code{test},\code{typeOfTest},
\code{adCor}, \code{nBlox}, \code{nReps},
\code{funName}, and \code{varNames}

\code{probs} Table of relative frequency and auto-dependency
}
\description{
Calculate the link strength between multiple behaviors and return them as a matrix (optionally discarting all non-significant links)
}
\examples{
netdata=cbind(rep(c(1,1,1,1,1,0,0,0,0,0),100),
rep(c(0,0,1,1,1,1,0,0,0,0),100))
conNEcT(netdata,lag=1,conFun=funKappa,test=TRUE,nBlox=5)
}
