% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResidualPredictionTest.R
\name{ResidualPredictionTest}
\alias{ResidualPredictionTest}
\title{Residual prediction test.}
\usage{
ResidualPredictionTest(Y, E, X, alpha = 0.05, verbose = FALSE,
  degree = 4, basis = c("nystrom", "nystrom_poly", "fourier",
  "polynomial", "provided")[1], resid_type = "OLS", XBasis = NULL,
  noiseMat = NULL, getnoiseFct = function(n, ...) {     rnorm(n) },
  argsGetNoiseFct = NULL, nSim = 100, funcOfRes = function(x) {    
  abs(x) }, useX = TRUE, returnXBasis = FALSE,
  nSub = ceiling(NROW(X)/4), ntree = 100, nodesize = 5,
  maxnodes = NULL)
}
\arguments{
\item{Y}{An n-dimensional vector.}

\item{E}{An n-dimensional vector or an nxq dimensional matrix or dataframe.}

\item{X}{A matrix or dataframe with n rows and p columns.}

\item{alpha}{Significance level. Defaults to 0.05.}

\item{verbose}{If \code{TRUE}, intermediate output is provided. Defaults to \code{FALSE}.}

\item{degree}{Degree of polynomial to use if  \code{basis="polynomial"} or  \code{basis="nystrom_poly"}.
Defaults to 4.}

\item{basis}{Can be one of  \code{"nystrom","nystrom_poly","fourier","polynomial","provided"}. Defaults to  \code{"nystrom"}.}

\item{resid_type}{Can be  \code{"Lasso"} or  \code{"OLS"}. Defaults to  \code{"OLS"}.}

\item{XBasis}{Basis if  \code{basis="provided"}. Defaults to \code{NULL}.}

\item{noiseMat}{Matrix with simulated noise. Defaults to NULL in which case the
simulation is performed inside the function.}

\item{getnoiseFct}{Function to use to generate the noise matrix. Defaults to \code{function(n, ...){rnorm(n)}}.}

\item{argsGetNoiseFct}{Arguments for \code{getnoiseFct}. Defaults to \code{NULL}.}

\item{nSim}{Number of simulations to use. Defaults to 100.}

\item{funcOfRes}{Function of residuals to use in addition to predicting the
conditional mean. Defaults to \code{function(x){abs(x)}}.}

\item{useX}{Set to \code{TRUE} if the predictors in X should also be used when
predicting the scaled residuals with E. Defaults to \code{TRUE}.}

\item{returnXBasis}{Set to \code{TRUE} if basis expansion should be returned. Defaults to \code{FALSE}.}

\item{nSub}{Number of random features to use if  \code{basis} is one of  \code{"nystrom","nystrom_poly"} or  \code{"fourier"}.
Defaults to \code{ceiling(NROW(X)/4)}.}

\item{ntree}{Random forest parameter: Number of trees to grow. Defaults to 500.}

\item{nodesize}{Random forest parameter: Minimum size of terminal nodes. Defaults to 5.}

\item{maxnodes}{Random forest parameter: Maximum number of terminal nodes trees in the forest can have.
Defaults to NULL.}
}
\value{
A list with the following entries:
\itemize{
 \item \code{pvalue} The p-value for the null hypothesis that Y and E are independent given X.
 \item \code{XBasis} Basis expansion if \code{returnXBasis} was set to \code{TRUE}.
 \item \code{fctBasisExpansion} Function used to create basis expansion if basis is not  \code{"provided"}.
 }
}
\description{
Tests the null hypothesis that Y and E are independent given X.
}
\examples{
# Example 1
n <- 100
E <- rbinom(n, size = 1, prob = 0.2)
X <- 4 + 2 * E + rnorm(n)
Y <- 3 * (X)^2 + rnorm(n)
ResidualPredictionTest(Y, as.factor(E), X)

# Example 2
E <- rbinom(n, size = 1, prob = 0.2)
X <- 4 + 2 * E + rnorm(n)
Y <- 3 * E + rnorm(n)
ResidualPredictionTest(Y, as.factor(E), X)

# not run:
# # Example 3
# E <- rnorm(n)
# X <- 4 + 2 * E + rnorm(n)
# Y <- 3 * (X)^2 + rnorm(n)
# ResidualPredictionTest(Y, E, X)
# ResidualPredictionTest(Y, X, E)
}
