% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation_mechanism.R
\name{generate_multiview}
\alias{generate_multiview}
\title{Multiview generation}
\usage{
generate_multiview(
  X,
  cluster.method = "pam",
  range.k = c(2, 5),
  sample.k.method = "random",
  rep = 10,
  distance.method = "euclidian",
  sample.set = NA,
  func
)
}
\arguments{
\item{X}{list of input data matrices of Sample x feature or distance matrices.
The length of \code{X} is equal to Nviews}

\item{cluster.method}{base clustering method: \code{c("kmeans", "pam", "custom")}}

\item{range.k}{vector of minimum and maximum values for k \code{c(min, max)}}

\item{sample.k.method}{method for the choice of k at each repeat \code{c("random", "silhouette")}}

\item{rep}{number of repeats}

\item{distance.method}{method for distance calculation:
\code{"euclidian"}, \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"}, \code{"minkowski"}.}

\item{sample.set}{vector of samples the clustering is being applied on. can be names or indices.
If \code{sample.set} is \code{NA}, it considers all the datasets have the same samples with the same order}

\item{func}{user-definrd function required if \code{cluster.method = "custom"}.
The function needs two inputs of X and k.}
}
\value{
matrix of clusterings Nsample x Nrepeat
}
\description{
Multiview generation
}
\details{
At each repeat, k is selected randomly or based on the best silhouette width from a discrete uniform distribution between range.k[1] and range.k[2].
Then clustering is applied and result is returned.
}
\examples{
data = multiview_clusters (n = c(40,40,40), hidden.dim = 2, observed.dim = c(2,2,2),
sd.max = .1, sd.noise = 0, hidden.r.range = c(.5,1))
X_observation = data[["observation"]]
Clusters = multiview_pam_gen(X_observation)

}
