% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DivideTheDollarGame.R
\name{divideTheDollarGame}
\alias{divideTheDollarGame}
\title{Construct a divide-the-dollar game}
\usage{
divideTheDollarGame(n)
}
\arguments{
\item{n}{represents the number of players}
}
\value{
A list with two elements 
representing the divide-the-dollar game (n, Game vector v)
}
\description{
\strong{Create a list containing 
all information about a specified divide-the-dollar game:} \cr
Returns a divide-the-dollar game with \code{n} players: \cr
This sample game is taken from the book 'Social and Economic Networks' by Matthew O. Jackson (see p. 413 ff.). 
If coalition \code{S} has at least \code{n/2} members it generates a value of \code{1}, otherwise \code{0}. \cr
Note that divide-the-dollar games are always simple games.
}
\section{Related Functions}{
 
\link{divideTheDollarGameValue}, \link{divideTheDollarGameVector}
}

\examples{
library(CoopGame)
divideTheDollarGame(n=3)

\donttest{
#Example with four players
library(CoopGame)
(vv<-divideTheDollarGame(n=4))
#$n
#[1] 4

#$v
#[1] 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1
}

}
\references{
Jackson M.O. (2008)  \emph{Social and Economic Networks}, Princeton University Press, p. 413
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
