% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicHelpIndexConcept.R
\name{drawPublicHelpIndex}
\alias{drawPublicHelpIndex}
\title{Draw Public Help index Theta for 3 or 4 players}
\usage{
drawPublicHelpIndex(
  v,
  holdOn = FALSE,
  colour = NA,
  label = TRUE,
  name = "Public Help Index"
)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawPublicHelpIndex draws the Public Help index Theta for a simple game with 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
drawPublicHelpIndex(v) 
}
\references{
Bertini C., Gambarelli G. and Stach I. (2008) "A public help index", In: Braham, M. and Steffen, F. (Eds): Power, freedom, and voting: Essays in Honour of Manfred J. Holler, pp. 83--98

Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25

Stach I. (2016) "Power Measures and Public Goods", In: Nguyen, N.T. and Kowalczyk, R. (Eds.): Transactions on Computational Collective Intelligence XXIII, Springer, pp. 99--110
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
