% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getkCover.R
\name{getkCover}
\alias{getkCover}
\title{Compute k-cover of game}
\usage{
getkCover(v, k)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{k}{An integer specifying k in the k-cover}
}
\value{
numeric vector containing the k-cover of the given game 
if the k-cover exists, NULL otherwise
}
\description{
getkCover returns the k-cover for a given TU game 
according to the formula on p. 173 in the book by Driessen.
Note that the k-cover does not exist if condition (7.2) on 
p. 173 in the book by Driessen is not satisfied.
}
\examples{
library(CoopGame)
getkCover(c(0,0,0,9,9,12,18),k=1)

\donttest{
library(CoopGame)
#Example from textbook by Driessen, p. 175, with alpha = 0.6 and k = 2
alpha = 0.6
getkCover(c(0,0,0,alpha,alpha,0,1), k=2)
#[1] 0.0 0.0 0.0 0.6 0.6 0.0 1.0
}

}
\references{
Driessen T. (1998) \emph{Cooperative Games, Solutions and Applications}, Springer, p. 173
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
