% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BanzhafConcept.R
\name{rawBanzhafValue}
\alias{rawBanzhafValue}
\title{Compute raw Banzhaf Value}
\usage{
rawBanzhafValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
The return value is a numeric vector which contains the raw Banzhaf value for each player.
}
\description{
raw Banzhaf Value, i.e. the Banzhaf Value without the division by the scaling factor \eqn{2^{(n-1)}}
}
\examples{
library(CoopGame)
v = c(0,0,0,1,1,2,5)
rawBanzhafValue(v)

\donttest{
library(CoopGame)
v = c(0,0,0,2,2,3,5)
rawBanzhafValue(v)
#[1] 6 8 8
}

}
\references{
Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 118--119
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
