% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recMID.R
\name{recMID}
\alias{recMID}
\alias{plot.recMID}
\title{recMID.}
\usage{
recMID(
  mid = c(1, 0, 0),
  r = list(`M+H` = 1),
  fml = NULL,
  cutoff = 0.001,
  algo = c("CorMID", "Rdisop")
)

\method{plot}{recMID}(x, ...)
}
\arguments{
\item{mid}{A numeric vector with sum=1 and length of C atoms +1.}

\item{r}{Fragment ratios. A numeric vector with sum=1.}

\item{fml}{A compound formula.}

\item{cutoff}{Remove values below this threshold from output vector.}

\item{algo}{The algorithm used to estimate the isotopic distribution of a chemical formula.}

\item{x}{Object of class recMID.}

\item{...}{Further plotting parameters.}
}
\value{
A reconstructed MID, i.e. the relative intensity values that would be
 measured for the specified molecule `fml` with respect to parameters``mid`
 and `r`. The default values for `mid` and `r` are set to reflect natural
 abundance and no fragmentation.
}
\description{
\code{recMID} will reconstruct a measured GC-APCI-MS spectrum
 of a compound given its true MID and the fragment ratio.
}
\details{
\code{recMID} is basically the inverse function to \code{CorMID}.
 Providing a specific chemical formula together with information regarding
 the true MID and r, this function will compute a vector of ion intensities
 which can be expected in a GC-APCI-MS analysis for this compound.
}
\examples{
fml <- "C9H20O3Si2"
mid <- c(0.9,0,0,0.1)
r <- list("M+H"=0.8, "M-H"=0.1, "M+H2O-CH4"=0.1)
(rMID <- CorMID::recMID(mid=mid, r=r, fml=fml))
plot(rMID)
plot(x = rMID, ylim=c(0,max(rMID)))
plot(x = rMID, xlim=c(-2,12), ylim=NULL, col=2, lwd=12, las=2, xlab="label")
\donttest{
CorMID::CorMID(int = rMID, fml=fml, prec=0.001, r=unlist(r), trace_steps = TRUE)
}
}
