% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMicrobiome.R
\name{CoreMicrobiome}
\alias{CoreMicrobiome}
\title{Identification of Core Microbiome}
\usage{
CoreMicrobiome(otu_table, tax_table, metadata_table, filter_type, ...,
method, beta_diversity_method, top_percentage)
}
\arguments{
\item{otu_table}{A dataframe of OTUs where the first row is the OTU ID and column names refer to sites/sample names.}

\item{tax_table}{A dataframe of taxonomies where the first row is the OTU ID and column names refer to taxonomic classification.}

\item{metadata_table}{A dataframe of sites/samples where the first row is the sites/sample names and column names refer to groups of samples.}

\item{filter_type}{Filtering method type, includes "abundance_fun_filter", "occupancy_fun_filter", or "combined_filter".}

\item{...}{Other parameters. These are ignored, except in filter_type = "abundance_fun_filter" which accepts min_count, prop, min_total_count parameter, and in filter_type = "occupancy_fun_filter" which accepts percent parameter, and also filter_type = "combined_filter" which accepts percent, min_count, prop, min_total_count parameters.}

\item{method}{Different normalization methods, includes "rrarefy", "srs", "css", "tmm", "tmmwsp", "rle", "upperquartile" or "none". The default method is tmm.}

\item{beta_diversity_method}{Different beta diversity methods, includes "bray", "jaccard", "mountford". The default method is bray.}

\item{top_percentage}{Percentage used for Core OTUs identification and the default is 10 percent.}
}
\value{
This function gives the list  which consist of following results.

`final_otu_table_bef_filter`  otu_table obtained after sorting according to the provided tax_table and metadata_table

`filtered_md_table` metadata_table obtained after sorting according to the provided otu_table

`final_otu_aft_filter` otu_table obtained after filtering according to the user defined filtering method

`normalized_table` normalized_otu_table obtained after normalizing according to the user defined normalization method

`alpha_diversity` Alpha diversity measures of the samples

`beta_diversity` Beta diversity measures between the samples

`core_otus` Core OTUs obtained

`non_core_otus` Non Core OTUs obtained

`core_otus_tax` Taxonomy of the obtained Core OTUs

`core_otus_count_data` Original count data of the obtained core OTUs

`core_otus_relative_abundance` Relative abundance data of the obtained core OTUs
}
\description{
This function provides a comprehensive pipeline for processing
OTU (Operational Taxonomic Unit) tables, taxonomic tables, and metadata tables.
It applies various filtering methods based on user-defined parameters to select
core OTUs and non-core OTUs calculates alpha and beta diversity measures.
The pipeline can be customized with different normalization methods and filtering
criteria. Taxa are ranked in descending according to the cumulative sum obtained.
This method assigns taxa to the core if they are in the top X\% of reads. Any taxa which appears before some cutoff percentage is included in the core.
}
\examples{
#To run input data
core_1 <- CoreMicrobiome(
 otu_table = demo_otu,
 tax_table = demo_tax,
 metadata_table = demo_md,
 filter_type = "occupancy_fun_filter", #Or "abundance_fun_filter", Or "combined_filter"
 percent = 0.5,
 method = "css",  # Or "srs", "rrarefy", "tmm", "tmmwsp", "rle", "upperquartile", "none"
 beta_diversity_method = "jaccard",
 top_percentage = 10  # Adjust the percentage as needed for core/non-core OTUs
)

#To view the core otus obtained
core_1[["core_otus"]]
#To view the taxonomy of the obtained core otus
core_1[["core_otus_tax"]]
}
\references{
Pereira, M., Wallroth, M., Jonsson, V. et al. (2018). Comparison of normalization methods for the analysis of metagenomic gene abundance data. BMC Genomics 19, 274. <doi:https://doi.org/10.1186/s12864-018-4637-6>

Beule L, Karlovsky P. (2020). Improved normalization of species count data in ecology by scaling with ranked subsampling (SRS): application to microbial communities. PeerJ 8:e9593.<doi:https://doi.org/10.7717/peerj.9593>
}
