% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize}
\alias{visualize}
\title{Visualizing the effect of minimum count on the core size}
\usage{
visualize(filtered_otu, min_count_val, max_count_val, count_val_interval,
prop, min_total_count, method, top_percentage)
}
\arguments{
\item{filtered_otu}{A dataframe of OTUs obtained before filtering which is retrieved from CoreMicrobiome function where the first row is the OTU ID and column names refer to sites/sample names}

\item{min_count_val}{A numeric value of Minimum count for each OTU to be present in each to be included after the filtering}

\item{max_count_val}{A numeric value of Maximum count for each OTU to be present in each to be included after the filtering}

\item{count_val_interval}{Count value interval for each OTU to be present in each to be included after the filtering}

\item{prop}{Minimum proportion of samples in which an OTU must be present}

\item{min_total_count}{Minimum total count for each OTU to be included after the filtering}

\item{method}{Different normalization methods, includes "rrarefy", "srs", "css", "tmm", or "none"}

\item{top_percentage}{Percentage used for obtaining the Core OTUs}
}
\value{
This function gives a line plot which shows change in number of core OTUs with minimum count
}
\description{
The visualize function generates interactive line plots that
allow users to explore the impact of different min_count values on the number of
core OTUs. Users can interact with the plots to examine the relationship between
filtering criteria and core OTU identification visually.
}
\examples{
#To run input data
core_1 <- CoreMicrobiome(
 otu_table = demo_otu,
 tax_table = demo_tax,
 metadata_table = demo_md,
 filter_type = "occupancy_fun_filter", #Or "abundance_fun_filter", Or "combined_filter"
 percent = 0.5,
 method = "css",  # Or "srs", "rrarefy", "tmm", "tmmwsp", "rle", "upperquartile", "none"
 beta_diversity_method = "jaccard",
 top_percentage = 10  # Adjust the percentage as needed for core/non-core OTUs
)
#To view the line plot
visualize(filtered_otu = core_1[["final_otu_table_bef_filter"]],
         min_count_val = 5,
         max_count_val = 25,
         count_val_interval = 5,
         prop = 0.1,
         min_total_count = 10,
         method = "srs",
         top_percentage =10)
}
