% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knockoff_filter.R
\name{calculate_w_statistics}
\alias{calculate_w_statistics}
\title{Calculate W Statistics for Knockoff Analysis}
\usage{
calculate_w_statistics(t_orig, t_knock, method = "median")
}
\arguments{
\item{t_orig}{Vector of test statistics for original variables}

\item{t_knock}{Vector or list of test statistics for knockoff variables.
If a list, should contain M vectors of the same length as t_orig.}

\item{method}{Method for computing W statistics:
\itemize{
  \item "difference": W_j = T_j - max(T_\{j,k\}) (default)
  \item "median": Uses Model-X knockoff median-based statistics
  \item "ratio": W_j = T_j / max(T_\{j,k\})
}}
}
\value{
Vector of W statistics for variable selection
}
\description{
Computes W statistics by comparing test statistics from original variables
with those from their knockoff counterparts. These statistics are used
for variable selection with FDR control.
}
\examples{
\donttest{
# Example with difference method
t_orig <- c(5.2, 3.1, 8.7, 2.4, 6.9)
t_knock <- list(
  c(2.1, 4.2, 3.3, 1.8, 2.9),
  c(1.9, 3.8, 4.1, 2.2, 3.1)
)

w_median <- calculate_w_statistics(t_orig, t_knock, method = "median")
w_diff <- calculate_w_statistics(t_orig, t_knock, method = "difference")
}
}
