% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breeding_metrics.R
\name{breeding_metrics}
\alias{breeding_metrics}
\title{Breeding Metrics Calculation}
\usage{
breeding_metrics(data, genotype_col, trait_col, replication_col)
}
\arguments{
\item{data}{A data frame containing the dataset with required columns.}

\item{genotype_col}{Character. Name of the genotype column.}

\item{trait_col}{Character. Name of the trait column.}

\item{replication_col}{Character. Name of the replication column.}
}
\value{
A list containing:
\itemize{
  \item `ANOVA`: The summary of the ANOVA table.
  \item `GenotypicVariance`: Genotypic variance, which measures the genetic variability among genotypes.
  \item `EnvironmentalVariance`: Environmental variance, which reflects the variability due to environmental factors.
  \item `PhenotypicVariance`: Phenotypic variance, the sum of genotypic and environmental variances.
  \item `GCV`: Genotypic coefficient of variation, expressed as a percentage of the mean.
  \item `PCV`: Phenotypic coefficient of variation, expressed as a percentage of the mean.
  \item `Heritability`: Broad-sense heritability, the proportion of phenotypic variance attributable to genetic variance.
  \item `GeneticAdvance`: Genetic advance under selection, a measure of genetic improvement.
  \item `GAPercentage`: Genetic advance as a percentage of the mean, indicating the relative genetic improvement.
}
}
\description{
This function calculates key breeding metrics such as genotypic variance, environmental variance, 
genotypic coefficient of variation (GCV), phenotypic coefficient of variation (PCV), heritability, 
and genetic advance (GA). These metrics are critical for assessing genotype performance and 
genetic potential in crop breeding experiments.
}
\examples{
\donttest{
set.seed(123)
data <- data.frame(
  Genotype = rep(c("G1", "G2", "G3"), each = 10),
  Replication = rep(1:10, times = 3),
  Trait = c(rnorm(10, 50, 5), rnorm(10, 55, 5), rnorm(10, 60, 5))
)
result <- breeding_metrics(data, "Genotype", "Trait", "Replication")
print(result)
}
}
\references{
Falconer, D. S. (1996). "Introduction to Quantitative Genetics". ISBN: 9780582243026.
Singh, R. K., & Chaudhary, B. D. (1985). "Biometrical Methods in Quantitative Genetic Analysis". ISBN: 9788122433764.
}
