% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossExpression.R
\name{cross_expression}
\alias{cross_expression}
\title{Computes cross-expression and co-expression p-values between all gene pairs.}
\usage{
cross_expression(
  data,
  locations,
  neighbor = 1,
  alpha_cross = 0.05,
  alpha_co = 0,
  output_matrix = FALSE
)
}
\arguments{
\item{data}{A cells by genes expression matrix.}

\item{locations}{A cells by coordinates (x-y or higher dimensions) matrix.}

\item{neighbor}{The n-th nearest neighbor for calculating cross-expression.}

\item{alpha_cross}{The significance threshold for cross-expression.}

\item{alpha_co}{The significance threshold for co-expression.}

\item{output_matrix}{If TRUE, outputs the cross-expression p-value matrix.}
}
\value{
Returns a list containing gene pairs with co-expression and cross-expression p-values
before and after false discovery rate (FDR) correction.
}
\description{
Computes cross-expression and co-expression p-values between all gene pairs.
}
\examples{
data("locations")
data("expression")
locations  = as.matrix(locations)
expression = as.matrix(expression)
expression = expression[,1:5]
results    = cross_expression(data = expression, locations = locations)

}
