% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quaternary.R
\name{plotQuaternary}
\alias{plotQuaternary}
\alias{plotQuaternary.default}
\title{Create quaternary simplex plots}
\usage{
plotQuaternary(x, ...)

\method{plotQuaternary}{default}(
  x,
  clusterVar,
  vertices,
  features = NULL,
  veloGraph = NULL,
  byCluster = NULL,
  processed = FALSE,
  method = c("euclidean", "cosine", "pearson", "spearman"),
  force = FALSE,
  sigma = 0.05,
  scale = TRUE,
  dotColorBy = NULL,
  dotColor = NULL,
  palette = "D",
  direction = 1,
  breaks = NULL,
  legendTitle = NULL,
  returnData = FALSE,
  ...
)
}
\arguments{
\item{x}{Input data. Can be a \code{matrix} or \code{dgCMatrix} object with
cells as columns, a \code{Seurat} or \code{SingleCellExperiment} object.}

\item{...}{
  Arguments passed on to \code{\link[=plotQuaternary.simMat]{plotQuaternary.simMat}}
  \describe{
    \item{\code{nGrid}}{Number of grids along the x-axis of the tetrahedron. Default
\code{10}.}
    \item{\code{radius}}{Arrow length of unit velocity. Lower this when arrows point
outside of the tetrahedron. Default \code{0.2}.}
    \item{\code{dotSize}}{Size of each dot. Default \code{0.6} for static figure, and
\code{4} for interactive view.}
    \item{\code{labelColors}}{Colors of the vertex labels. Default
\code{c("#3B4992FF", "#EE0000FF", "#008B45FF", "#631879FF")} (blue, red,
green and purple).}
    \item{\code{arrowLinewidth}}{Arrow aesthetics. Default \code{1.6} for interactive
view, \code{0.6} for static figure.}
    \item{\code{arrowAngle,arrowLen}}{Arrow aesthetics passed to TODOOOO
\code{grid::\link[grid]{arrow}}. The length of the arrow will be internally
converted to unit onject in inches. Default \code{20} and \code{0.1}.}
    \item{\code{edgeLinewidth}}{Controls the linewidth of the edges of the tetrahedron.
Default \code{1}.}
    \item{\code{vertexLabelSize}}{Numeric, size of vertex text label relative to default
size. Default \code{1}.}
    \item{\code{title}}{Title text of the plot. Default \code{NULL}.}
    \item{\code{titleSize,titleColor}}{Setting on the main title text. Default \code{1},
and \code{"black"}.}
    \item{\code{theta,phi}}{Numeric scalar. The angles defining the viewing direction.
\code{theta} gives the azimuthal direction and \code{phi} the colatitude.
Default \code{20} and \code{0}.}
    \item{\code{interactive}}{Logical. Whether to display plotly interactive view.
Default \code{TRUE}.}
  }}

\item{clusterVar}{A vector/factor assigning the cluster variable to each
column of the matrix object. For "Seurat" method, \code{NULL} (default) for
\code{Idents(x)}, or a variable name in \code{meta.data} slot. For
"SingleCellExperiment" method, \code{NULL} (default) for \code{colLabels(x)},
or a variable name in \code{colData} slot.}

\item{vertices}{Vector of three unique cluster names that will be used for
plotting. Or a named list that groups clusters as three terminal vertices.
There must not be any overlap between groups.}

\item{features}{Valid matrix row subsetting index to select features for
similarity calculation. Default \code{NULL} uses all available features.}

\item{veloGraph}{Cell x cell \code{dgCMatrix} object containing velocity
information. Shows velocity grid-arrow layer when specified. Default
\code{NULL} does not show velocity.}

\item{byCluster}{Default \code{NULL} to generate one plot with all cells.
Set \code{"all"} to split cells in plot by cluster and returns a list of
subplots for each cluster as well as the plot including all cells. Otherwise,
a vector of cluster names to generate a list of subplots for the specified
clusters.}

\item{processed}{Logical. Whether the input matrix is already processed.
\code{TRUE} will bypass internal preprocessing and input matrix will be
directly used for similarity calculation. Default \code{FALSE} and raw count
input is recommended. If missing in call, using \code{slot = "counts"} in
"Seurat" method or using \code{assay.type = "counts"} in
"SingleCellExperiment" method will force this argument to be \code{FALSE} and
others for \code{TRUE}.}

\item{method}{Similarity calculation method. Default \code{"euclidean"}.
Choose from \code{"euclidean"}, \code{"cosine"}, \code{"pearson"},
\code{"spearman"}.}

\item{force}{Whether to force calculate the similarity when more then 500
features are detected, which is generally not recommended. Default
\code{FALSE}.}

\item{sigma}{Gaussian kernel parameter that controls the effect of variance.
Only effective when using a distance metric (i.e. \code{method} is
\code{"euclidian"} or \code{"cosine"}). Larger values tighten the dot
spreading on figure. Default \code{0.05}.}

\item{scale}{Whether to min-max scale the distance matrix by clusters.
Default \code{TRUE}.}

\item{dotColorBy}{A vector/factor for coloring dots, can be either categorical
(must be character or factor) or continuous. Default \code{NULL}.}

\item{dotColor}{Character vector of color codes. When \code{dotColorBy} is
\code{NULL}, use one or as many colors as the number of cells. If
\code{dotColorBy} is categorical, specify as many colors
as the number of categories in \code{dotColorBy} or ggplot2 categorical
color palette is used by default. If \code{dotColorBy} is continuous, specify
together with \code{breaks} argument.}

\item{palette}{Color palette to use when \code{dotColorBy} is given. Default
\code{"D"} (viridis) for continuous value and ggplot2 default for categorical
value. See detail for alternatives.}

\item{direction}{Sets the order of colors in the scale. Default \code{1}
orders as palette default. If \code{-1}, the order of colors is reversed.}

\item{breaks}{Number of breaks for continuous color scale passed to
non-interactive "plot3D::scatter3D" call. Default \code{NULL}.}

\item{legendTitle}{Title on the legend/colorbar. Default \code{NULL} uses
\code{"cluster"} if \code{dotColorBy} is missing (default); user-end variable
expression if \code{dotColorBy} is directly specified from
plotQuaternary.default method; variable name if \code{dotColorBy} is
specified from Seurat or SingleCellExperiment method.}

\item{returnData}{Logical. Whether to return similarity and aggregated
velocity data if applicable instead of generating plot. Default \code{FALSE}.}
}
\value{
By default, a "plotly" object. When \code{interactive = FALSE}, a
"quatPlot" object when \code{byCluster} is not specified, or a "list" of
"quatPlot" objects when \code{byCluster} is specified. When
\code{returnData = TRUE}, a list of similarity matrix and aggregated velocity
matrix is returned.
}
\description{
Create quaternary plots that show similarity between single cells and
selected four terminals in a baricentric coordinate.

See \code{\link{plotTernary}} for more details on methodologies.

A dynamic rotating view in a GIF image file can be created with
\code{\link{writeQuaternaryGIF}}. Package \code{magick} must be installed in
advance. Linux users may refer to this
\href{https://cran.r-project.org/package=magick/vignettes/intro.html#Build_from_source}{installation guide}.
}
\examples{
gene <- selectTopFeatures(
    x = rnaRaw,
    clusterVar = rnaCluster,
    vertices = c("RE", "OS", "CH", "ORT")
)
plotQuaternary(
    x = rnaRaw,
    clusterVar = rnaCluster,
    vertices = c("RE", "OS", "CH", "ORT"),
    features = gene
)
}
\seealso{
Other plotQuaternary: 
\code{\link{plotQuaternary.Seurat}()},
\code{\link{plotQuaternary.SingleCellExperiment}()}
}
\concept{plotQuaternary}
