% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/induce.cfe.R
\name{induce.cfe}
\alias{induce.cfe}
\title{induce.cfe}
\usage{
induce.cfe(floor.perc, ceiling.perc, y)
}
\arguments{
\item{floor.perc}{a (non-empty) numeric value from 0 to 1 denoting the desired percentage of floor effects}

\item{ceiling.perc}{a (non-empty) numeric value from 0 to 1 denoting the desired percentage of ceiling effects}

\item{y}{a (non-empty) numeric vector of data}
}
\value{
y scores with induced ceiling/floor effects
}
\description{
inducing ceiling/floor effects in data
}
\examples{
x=rnorm(1000,0,1) #simulate "healthy data"
x.c20=induce.cfe(0,.2,x) #induce 20\% ceiling effects into the data
sum(x.c20==max(x.c20))/length(x.c20) #check ceiling percentage
x.f20=induce.cfe(.2,0,x) #induce 20\% floor effects into the data
sum(x.f20==min(x.f20))/length(x.f20) #check ceiling percentage
}
