% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_asr_clade.R
\name{extract_asr_clade}
\alias{extract_asr_clade}
\title{Extracts an island clade based on the ancestral state reconstruction of the
species presence on the island, therefore this clade can contain
non-endemic species as well as endemic species.}
\usage{
extract_asr_clade(phylod, species_label, clade, include_not_present)
}
\arguments{
\item{phylod}{A \code{phylo4d} object from the package \code{phylobase} containing
phylogenetic and endemicity data for each species.}

\item{species_label}{The tip label of the species of interest.}

\item{clade}{A numeric vector which the indices of the species which are
in the island clade.}

\item{include_not_present}{A boolean determining whether species not present
on the island should be included in island colonist when embedded within an
island clade. Default is FALSE.}
}
\value{
An object of \code{Island_colonist} class
}
\description{
Extracts an island clade based on the ancestral state reconstruction of the
species presence on the island, therefore this clade can contain
non-endemic species as well as endemic species.
}
