% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiEvaluate.R
\name{evaluate_attribute}
\alias{evaluate_attribute}
\title{evaluate_attribute}
\usage{
evaluate_attribute(model, attribute, alternative, seq = NULL, ...)
}
\arguments{
\item{model}{A \link{DexiModel}.}

\item{attribute}{A \link{DexiAttribute} with an assigned discrete or continuous scale.}

\item{alternative}{A \code{data.frame} containing a single alternative.}

\item{seq}{A sequence of \code{attribute} numeric values for which to evaluate \code{alternative}.
For discrete scales: Must be a sequence of integers. Defaults to \code{attribute$scale$full_range()}.
For continuous scales: \code{seq} is required.}

\item{...}{Optional parameters passed to \code{\link[=evaluate]{evaluate()}}.}
}
\value{
A list of evaluated alternatives for consecutive \code{attribute} values from \code{seq}.
}
\description{
Evaluate \code{alternative} for a sequence of \code{attribute} values.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

alt <- Car$alternative("MyCar",
         BUY.PRICE="low", MAINT.PRICE=2, X.PERS="more", X.DOORS="4", LUGGAGE=2, SAFETY="medium")
safety <- Car$attrib("SAFETY")
# Evaluate alt for all values of att
evaluate_attribute(Car, safety, alt)
# Returns a list of three alternatives for values SAFETY=c("small", "medium", "high")
}
\seealso{
\code{\link[=evaluate]{evaluate()}}
}
