% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAlternatives.R
\name{export_alternatives}
\alias{export_alternatives}
\title{export_alternatives}
\usage{
export_alternatives(model, alternatives = NULL)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{alternatives}{A \code{data.frame} of alternatives (normally an output of \code{\link[=evaluate]{evaluate()}}) or
indices to \code{model$alternatives}. The default value \code{NULL} selects \code{model$alternatives}.}
}
\value{
A data frame consisting of character strings that can be further written out by \code{\link[=write_alternatives]{write_alternatives()}}.
}
\description{
Convert \code{alternatives}' data to a data frame formatted so that it can be
imported by DEXi/DEXiWin software.
}
\details{
In order to import the output of \code{export_alternative()} in DEXi/DEXiWin software,
proper \code{Import/Export} settings must be ensured in these programs:
\describe{
\item{DEXi}{Option values: "base 1", Attributes: "all", Orientation: "normal",
Indent: "indent".}
\item{DEXiWin}{Option values: "Base 1", Attributes: "All",
Orientation: "Attributes \ Alternatives",
Indent: "Indent tree levels",
CSV Format: "Invariant" when \code{format = "csv"} and "Local" when \code{format = "csv2"}.}
}
If \code{alternatives} contain value distributions,
they can be imported only by DEXiWin and not by DEXi.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

export_alternatives(Car)    # export both alternatives from Car
export_alternatives(Car, 1) # export only the first alternative

}
\seealso{
\code{\link[=write_alternatives]{write_alternatives()}}
}
