% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{rule_values}
\alias{rule_values}
\title{rule_values}
\usage{
rule_values(str, add = 0)
}
\arguments{
\item{str}{\code{character(1)}, a DEXi encoding of a vector of ordinal numbers.}

\item{add}{An integer constant to be added to the resulting vector. The default is \code{add = 0},
however DEXi's ordinal numbers should normally be converted to R's using \code{add = 1}.}
}
\value{
A numeric vector of the same length as \code{str}.
}
\description{
Values of decision rules are in \code{.dxi} files encoded using character strings, where each
individual character encodes some function value. The encoding is zero-based, so that
the character \code{"0"} represents the lowest ordinal number on the corresponding discrete scale.
Encoding of characters is according to ASCII, starting with \code{"0"}.
\code{rule_values(str)} converts the character string to a numeric vector of corresponding
ordinal values.
}
\examples{
rule_values("01122:")
rule_values("01122:", add = 1)

}
