% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAlternatives.R
\name{select_quality}
\alias{select_quality}
\title{select_quality}
\usage{
select_quality(model, alt, quality)
}
\arguments{
\item{model}{A \link{DexiModel} object.}

\item{alt}{\code{data.frame}. A single DEXi alternative.}

\item{quality}{Requested \code{EnumQuality}: \code{"bad"}, \code{"good"} or \code{"none"}.}
}
\value{
\code{alt} containing only values that have the requested quality.
}
\description{
Select from \code{alt} only those attributes whose values have the given \code{quality}.
Used primarily in \code{selective_explanation()}.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

alt <- Car$alternative("MyCar",
       BUY.PRICE="low", MAINT.PRICE="*", X.PERS="more", X.DOORS="4", LUGGAGE=2, SAFETY=c(1, 3))
alte <- Car$evaluate(alt)
alts <- select_quality(Car, alte, "bad")
names(alts)
# c("CAR", "PRICE", "MAINT.PRICE", "TECH.CHAR.", "SAFETY")
alts <- select_quality(Car, alte, "none")
names(alts)
# c("MAINT.PRICE", "X.DOORS", "LUGGAGE")
alts <- select_quality(Car, alte, "good")
names(alts)
# c("CAR", "PRICE", "BUY.PRICE", "MAINT.PRICE", "TECH.CHAR.", "COMFORT", "X.PERS", "SAFETY")
}
\seealso{
\code{\link[=value_qualities]{value_qualities()}}, \code{\link[=selective_explanation]{selective_explanation()}}
}
