% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{value_to_set}
\alias{value_to_set}
\title{value_to_set}
\usage{
value_to_set(value, scale)
}
\arguments{
\item{value}{A DEXi value, internal representation: numeric value or vector, or \link{distribution}.}

\item{scale}{A \link{DexiScale} or derived object.}
}
\value{
An integer vector or \code{NA} for: non-discrete scale, \code{NA}/\code{NULL} value(s), non-integer value(s).
}
\description{
value_to_set
}
\examples{
scl <- DexiDiscreteScale(values = c("low", "med", "high"))
value_to_set(1, scl)                       # 1
value_to_set(1:2, scl)                     # c(1, 2)
value_to_set(c(1,3), scl)                  # c(1, 3)
value_to_set(distribution(1, 0, 0.5), scl) # c(1, 3)
}
