% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCDIF.R
\name{PlotNcdif}
\alias{PlotNcdif}
\title{Plot the item characteristic (expected score) curve for focal and reference groups for the iiItem along with a
  representation of the focal group density.}
\usage{
PlotNcdif(
  iiItem,
  itemParameters,
  irtModel = "2pl",
  logistic = TRUE,
  plotDensity = FALSE,
  focalAbilities = NULL,
  focalDistribution = "norm",
  focalDistrExtra = list(mean = 0, sd = 1),
  from = -5,
  to = 5,
  thetaInt = 0.01,
  colour = TRUE,
  highColour = "blue",
  main = "",
  xlab = "Ability",
  ylab = "Probability",
  iccText = "Group ICCs",
  focalIccText = "Focal group ICC",
  referenceIccText = "Reference group ICC",
  focalDensityText = "Focal group density"
)
}
\arguments{
\item{iiItem}{Item (row) number for the item in each of the itemParameter matrices to plot.}

\item{itemParameters}{A list containing "focal" and "reference" item parameters. Item parameters are assumed to be on the same scale. Item parameters for each group should me a matrix with nrow equal to the number of items.}

\item{irtModel}{A string stating the irtModel to be used. Should be one of "1pl", "2pl", "3pl", "grm" or "pcm".}

\item{logistic}{A logical value stating if the IRT model will use the logistic or the normal metric.}

\item{plotDensity}{logical indicating if the focal distribution density should be plotted as a density curve (TRUE) or if it should be represented as an area gradient (FALSE). Defaults to gradient.}

\item{focalAbilities}{If NULL, density is calculated theoretically from focal distribution. If not NULL, it must be a numerical vector containing the abilities for the individuals in the focal group.}

\item{focalDistribution}{A string stating the distribution name to be used for density calculation. Only used if focalAbilities is NULL.}

\item{focalDistrExtra}{Extra parameters for the focal group distribution function if needed.}

\item{from}{value on the x-axis to serve as minimum for the plot}

\item{to}{value on the x-axis to serve as maximum for the plot}

\item{thetaInt}{value for the x-axis step for probabilities and density evaluation. Only used if focalAbilities is NULL.}

\item{colour}{logical value indicating if the area gradient should be presented in colour when plotDensity is FALSE, or if the different lines should be presented in colour when plotDensity is TRUE.}

\item{highColour}{character indicating the colour text name that should be used for high density regions.}

\item{main}{text for plot main title.}

\item{xlab}{text for x-axis label.}

\item{ylab}{text for y-axis label.}

\item{iccText}{text for legend title related to ICC curves.}

\item{focalIccText}{legend for focal group ICC curve.}

\item{referenceIccText}{legend for reference group ICC curve.}

\item{focalDensityText}{legend for focal group density curve when plotDensity is TRUE. Text for legend title related to the colour gradient when plotDensity is FALSE.}
}
\value{
plotNCDIF  A ggplot object for the plot
}
\description{
Plot the item characteristic (expected score) curve for focal and reference groups for the iiItem along with a
  representation of the focal group density.
}
\examples{

data(dichotomousItemParameters)

threePlParameters <- dichotomousItemParameters
isNot3Pl          <- ((dichotomousItemParameters[['focal']][, 3] == 0) |
                      (dichotomousItemParameters[['reference']][, 3] == 0))

threePlParameters[['focal']]          <- threePlParameters[['focal']][!isNot3Pl, ]
threePlParameters[['reference']]      <- threePlParameters[['reference']][!isNot3Pl, ]
threePlParameters[['focal']][, 3]     <- threePlParameters[['focal']][, 3] + 0.1
threePlParameters[['reference']][, 3] <- threePlParameters[['reference']][, 3] + 0.1
threePlParameters[['focal']][, 2]     <- threePlParameters[['focal']][, 2] + 1.5
threePlParameters[['reference']][, 2] <- threePlParameters[['reference']][, 2] + 1.5
threePlParameters[['focal']]          <- threePlParameters[['focal']][-c(12, 16, 28), ]
threePlParameters[['reference']]      <- threePlParameters[['reference']][-c(12, 16, 28), ]

# # Non Uniform - != guess DIF item
PlotNcdif(iiItem = 22, itemParameters = threePlParameters, irtModel = "3pl",
          plotDensity = FALSE, main = "Item 22 Non uniform and different guessing DIF. 3PL")

# # Uniform - != guess DIF item
PlotNcdif(iiItem = 15, itemParameters = threePlParameters, irtModel = "3pl",
          plotDensity = FALSE, main = "Item 15 Uniform and different guessing DIF. 3PL")

}
\author{
Victor H. Cervantes <vhcervantesb at unal.edu.co>
}
