test_that("stein_beta calculates Stein's Beta for each cluster", {


  # Create a sample dataset with beta estimates and clusters
  set.seed(123)
  sample_data <- data.frame(
    cluster_id = rep(1:3, each = 4),
    estimate_gender_female = rnorm(12, 0, 1)  # Random beta estimates
  )

  # Run the stein_beta function
  result <- stein_beta(
    data = sample_data,
    cluster_id = "cluster_id",
    beta = "estimate_gender_female"
  )

  # Check if the result contains the 'stein_beta' column
  expect_true("stein_beta" %in% colnames(result))

  # Ensure the output contains the same number of rows as the input
  expect_equal(nrow(result), nrow(sample_data))

  # Ensure that the stein_beta column is numeric
  expect_type(result$stein_beta, "double")
})
