% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monteCarloSimulation.R
\name{monteCarloSimulation}
\alias{monteCarloSimulation}
\title{Single-function Monte Carlo simulation and results export.}
\usage{
monteCarloSimulation(
  dir_path,
  iterations,
  foods_df,
  nutrient_targets_df,
  food_group_targets_df,
  person,
  diet,
  allowed_varieties,
  min_serve_size_difference,
  allow_discretionary = TRUE,
  allow_alcohol = TRUE,
  allow_takeaway = TRUE,
  emission_cols = NULL,
  nutrient_cols = NULL,
  nutrient_constraints = NULL,
  linked_low_1 = NULL,
  linked_high_1 = NULL,
  linked_low_2 = NULL,
  linked_high_2 = NULL
)
}
\arguments{
\item{dir_path}{A string containing the path where a directory will be created. This same path will hold the reports Excel workbook.}

\item{iterations}{Number of iterations. Integer.}

\item{foods_df}{Foods dataframe.}

\item{nutrient_targets_df}{Nutrient constraints dataframe.}

\item{food_group_targets_df}{Food group serves dataframe.}

\item{person}{Individual whose random meal plan will be created to. Can be one of man, woman, boy or girl.}

\item{diet}{Chosen diet. Must be DIETNAME from 'constraints_DIETNAME_diet_foods' sheet in dataset.}

\item{allowed_varieties}{Permitted food varieties. Can be a vector of the following: 1,2 and/or 3.}

\item{min_serve_size_difference}{Multiplier to serve difference. A float between 0 and 1.}

\item{allow_discretionary}{Boolean variable checking if discretionary foods are permitted. Default TRUE.}

\item{allow_alcohol}{Boolean variable checking if alcohol is permitted. Default TRUE.}

\item{allow_takeaway}{Boolean variable checking if takeaway is permitted. Default TRUE.}

\item{emission_cols}{Optional parameter. Emission column names if standard dataset isn't used.}

\item{nutrient_cols}{Optional parameter. Nutrients column names if standard dataset isn't used.}

\item{nutrient_constraints}{Optional parameter. Vector of nutrients column names to be used if not all nutrients are to be used as constraints.}

\item{linked_low_1}{Optional parameter. Vector of lower bound food IDs.}

\item{linked_high_1}{Optional parameter. Vector of higher bound food IDs.}

\item{linked_low_2}{Optional parameter. Vector of lower bound food IDs.}

\item{linked_high_2}{Optional parameter. Vector of higher bound food IDs.}
}
\value{
No R object return. Prints an Excel workbook.
}
\description{
Runs Monte Carlo Simulation and prints results, in .xlsx format, in a single funtion.
}
