% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{doypa_palette}
\alias{doypa_palette}
\title{Create a DOYPAColors color palette function}
\usage{
doypa_palette(
  palette = NULL,
  reverse = FALSE,
  gradient = FALSE,
  type = "all",
  colorblind = FALSE
)
}
\arguments{
\item{palette}{A character string specifying the name of the palette to use. If `NULL`, a random palette will be selected.}

\item{reverse}{A logical value indicating whether to reverse the order of colors in the palette. Default is `FALSE`.}

\item{gradient}{A logical value indicating whether to interpolate colors as a  gradient of `n` colors between the first and last colors of the palette. If `FALSE`, returns the first `n` colors of the palette.}

\item{type}{A character string specifying the type of palettes to select from: "all", "seq" (sequential), "div" (diverging), or "qual" (qualitative). Default is "all".}

\item{colorblind}{A logical value indicating whether to restrict the palette to colorblind-friendly options. Default is `FALSE`.}
}
\value{
A function that generates a vector of `n` colors or a color gradient.
}
\description{
This function creates a function that generates a color vector of `n` colors 
for a specified DOYPAColors palette. The generated function allows you to 
easily create customized color palettes with a specified number of colors.
}
\examples{
# Create a function for generating colors from the "buzz" palette
get_buzz_palette <- DOYPAColors:::doypa_palette(palette = "buzz")
color_palette <- get_buzz_palette(5)
print(color_palette)

}
\keyword{internal}
