% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_track_popularity.R
\name{get_track_popularity}
\alias{get_track_popularity}
\title{Get Track Popularity}
\usage{
get_track_popularity(track_uri, limit = 1, offset = 0,
  access_token = DSpoty::get_spotify_access_token())
}
\arguments{
\item{track_uri}{A track uri corresponding to one track in Spotify.}

\item{limit}{Integer indicating the max number of artists to return. Defaults to 1, max of 50.}

\item{offset}{Integer indicating the offset of the first artist to return. Defaults to 0 (Spotify's API default value).}

\item{access_token}{Spotify Web API token. Defaults to DSpoty::get_spotify_access_token().}
}
\value{
Returns an integer vector with the popularity value (0-100).
}
\description{
This function that returns the popularity of a track uri on Spotify.
}
\examples{
\dontrun{
popularity <- get_track_popularity('0FgNSsaSZTvbLXUumSO8LQ')
}
}
\author{
Alberto Almui?a
}
