% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_1DDTW.R
\name{local.derivative.ddtw}
\alias{local.derivative.ddtw}
\title{Local derivative estimate to compute DDTW}
\usage{
local.derivative.ddtw(X)
}
\arguments{
\item{X}{input vector from which local derivative has to be calculated}
}
\description{
This function estimates the local derivative of a vector.
It can be used as an input in dtw() function (package dtw) to align two univariate signals.
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1]
local.derivative.ddtw(X)

# Plot
plot(X, type = "b", ylim = c(-1, 1))
lines(local.derivative.ddtw(X), col = "red")
}
\author{
Camille Dezecache, Hong T. T. Phan, Emilie Poisson-Caillault
}
