% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.choose.rows.dt.choose.cols.dt.count.rows.R
\name{dt.choose.rows}
\alias{dt.choose.rows}
\title{dt.choose.rows}
\source{
DTwrappers::create.dt.statement

DTwrappers::eval.dt.statement
}
\usage{
dt.choose.rows(
  dt.name,
  the.filter = NULL,
  return.as = "result",
  envir = .GlobalEnv
)
}
\arguments{
\item{dt.name}{a character value specifying the name of a data.frame or data.table object to select data from.  A variable called dat should be referred to with dt.name = "dat" when using the function.}

\item{the.filter}{a character value, numeric vector, logical vector, or expression stating the logical operations used to filter the data.  The filtering step will be applied prior to generating the counts.  Defaults to NULL unless otherwise specified.  Character values such as 'Age < 50' or 'c(1:3, 7:10)' may be used.  Numeric vectors such as c(1:3, 7:10) that specify the row indices may be used.  Logical vectors will be converted to a numeric filter, e.g. c(TRUE, TRUE, FALSE) will become 1:2 to signify which rows should be selected.  Expressions may be used to specify a logical operation such as expression(Age < 50) as well.  Defaults to NULL to indicate that no filtering of the data should be applied.}

\item{return.as}{a character value specifying what output should be returned.  return.as = "result" provides the table of counts.  return.as = "code" provides a data.table coding statement that can generate the table of counts.  return.as = "all" provides both the resulting table and the code.  If the coding statement was specified using calls to get() or eval(), then both an original.statement and the resulting code (a translated statement from the getDTeval package) will be provided.}

\item{envir}{the environment in which the code would be evaluated; .GlobalEnv by default.}
}
\value{
Depending on the value of return.as, the output will be a) a character value (return.as = 'code'), b) a coding output, typically a data.table (return.as = 'result'), or c) a list containing both the code and output (return.as = 'all')
}
\description{
This function filters the rows of a data.table or data.frame object.  It is built as a wrapper function of data.table's filtering method (the i step).  A series of logical tests on variables within the data may be specified.  Options also exist to return a data.table coding statement (result = "code") for educational purposes or both the result and the code together (result = "all").  For examples, please see the vignette.
}
\note{
the data.frame dat will be converted to a data.table object to facilitate efficient counting of the rows.
}
\examples{
n <- nrow(iris)
dat <- data.table::as.data.table(x = iris[sample(x = 1:n, size = n, replace = FALSE),])
dt.count.rows(dt.name = "dat", count.name = "Total Rows", return.as = "all")
}
