% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnect.R
\name{DSConnect}
\alias{DSConnect}
\title{initializer}
\description{
initializer

initializer
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{Config}}{: config file path}

\item{\code{Username}}{: Your id}

\item{\code{Password}}{: Your Password}

\item{\code{Proxies}}{: Proxy Server details (if any)}

\item{\code{SslCert}}{: ssl Certifactes file path}

\item{\code{Url}}{: internal parameter set by application}

\item{\code{RequestUrl}}{: internal parameter set up by application}

\item{\code{Token}}{: Token received on successfull logon}

\item{\code{TokenExpiry}}{: Expiry time of the token}

\item{\code{Timeout}}{: Max Timeout set in Configuartion for the process to complete}

\item{\code{Version}}{: Application Version}

\item{\code{AppID}}{: Application Id}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DSConnect-new}{\code{DSConnect$new()}}
\item \href{#method-DSConnect-getJsonResponse}{\code{DSConnect$getJsonResponse()}}
\item \href{#method-DSConnect-getToken}{\code{DSConnect$getToken()}}
\item \href{#method-DSConnect-IsValid}{\code{DSConnect$IsValid()}}
\item \href{#method-DSConnect-CheckToken}{\code{DSConnect$CheckToken()}}
\item \href{#method-DSConnect-clone}{\code{DSConnect$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSConnect-new"></a>}}
\if{latex}{\out{\hypertarget{method-DSConnect-new}{}}}
\subsection{Method \code{new()}}{
DSConnect connects to the Datastream web service on behalf of derived classes
and helps to send and retrieve data


DSConnect connects to the Datastream web service on behalf of derived classes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSConnect$new(
  config = NULL,
  username = NA,
  password = NA,
  proxies = NULL,
  sslCert = NULL,
  service = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{: config path}

\item{\code{username}}{: your username}

\item{\code{password}}{: your password}

\item{\code{proxies}}{: proxy url, if any}

\item{\code{sslCert}}{: path to ssl cert file}

\item{\code{service}}{: internally set by the application}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
user details can be supplied from a config file or passed directly as parameters in the
constructor of the derived user object type class.

\if{html}{\out{<div class="sourceCode">}}\preformatted{   1) Using ini file (e.g. config.ini) with format

   [credentials]
   username=YourID
   password=YourPwd

   [proxies]
   url=Your Proxy Url
   port=Proxy port
   username=Proxy Username
   password=Proxy Password

   [cert]
   sslCertFile=YourCertFile
   #only read if no sslCertFile entry
   sslCertPath=YourCertPath
}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSConnect-getJsonResponse"></a>}}
\if{latex}{\out{\hypertarget{method-DSConnect-getJsonResponse}{}}}
\subsection{Method \code{getJsonResponse()}}{
This method makes the query against the API service and does some basic error handling
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSConnect$getJsonResponse(requestUrl, request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{requestUrl}}{: Url used to send the Post request}

\item{\code{request}}{: Raw Datastream request}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSConnect-getToken"></a>}}
\if{latex}{\out{\hypertarget{method-DSConnect-getToken}{}}}
\subsection{Method \code{getToken()}}{
getToken uses you credentials to try and obtain a token to be used in subsequent request for data.
The returned token is valid for 24 hours
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSConnect$getToken()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSConnect-IsValid"></a>}}
\if{latex}{\out{\hypertarget{method-DSConnect-IsValid}{}}}
\subsection{Method \code{IsValid()}}{
IsValid checks whether the token is valid against the token expiry time
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSConnect$IsValid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSConnect-CheckToken"></a>}}
\if{latex}{\out{\hypertarget{method-DSConnect-CheckToken}{}}}
\subsection{Method \code{CheckToken()}}{
CheckToken checks whether the token is valid against the token expiry time
and generates new token if the token has expired.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSConnect$CheckToken()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSConnect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DSConnect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSConnect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
