% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatastreamUserCreated_TimeSeries.R
\name{DSTimeSeriesUserObjectBase}
\alias{DSTimeSeriesUserObjectBase}
\title{DSTimeSeriesUserObjectBase}
\value{
DSTimeSeriesUserObjectBase object
}
\description{
This is the base object for creating or requesting timeseries data. It has two subclasses
DSTimeSeriesRequestObject and DSTimeSeriesResponseObject. It defines the basic attributes for a timeseries.
It subclasses DSUserObjectBase which defines the basic attributes common to all five user created item types
supported by the API.\cr
\cr
Specifics of some of the properties of the DSUserObjectBase superclass\cr
----------------------------------------------------------------------\cr
ID \cr The ID property is defined in DSUserObjectBase but has a specific format for timeseries. Timeseries IDs must be
8 alphanumeric characters long, start with TS followed by 6 uppercase
alphanumeric characters. For example: TSTEST01, TS123456, TSMYTEST, etc.\cr
Mnemonic \cr The Mnemonic property is defined in DSUserObjectBase but should always be left empty or set the same as the
ID property for timeseries requests. As a safety measure, this class always ensures it's the same as the ID.
In a response from the API server, the value will always be the same as the ID.\cr
(see DSUserObjectBase for a description of the other properties)\cr
\cr
DSTimeSeriesUserObjectBase specific properties
}
\section{Super class}{
\code{\link[DatastreamR:DSUserObjectBase]{DatastreamR::DSUserObjectBase}} -> \code{DSTimeSeriesUserObjectBase}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ManagementGroup}}{This is an optional group name that allows you to organise timeseries into distinct 'folders'
displayed in the search category of Navigator. This can be up to 10 uppercase alphanumeric characters. Leave blank for the
item to be assigned under the 'GENERAL' group.}

\item{\code{Units}}{This is a optional qualifying unit for your data. For example: tons, U$ millions, index, etc.
Maximum 12 characters.}

\item{\code{DecimalPlaces}}{A numeric value between 0 and 8 decimal places specifying how many decimal places to use when storing data.
The maximum length including decimals for a value is 10 characters including the decimal point. Boundary case examples are 0.12345678,
1234567890, 123456789.0, etc.}

\item{\code{FrequencyConversion}}{A DSTimeSeriesFrequencyConversion enum value specifying how to return values if a user requests data
at a lower frequency than the timeseries data is supplied. See DSTimeSeriesFrequencyConversion for details.}

\item{\code{DateAlignment}}{A DSTimeSeriesDateAlignment enum value specifying whether dates for certain frequencies should be returned
as the start, middle or end date of the period. See DSTimeSeriesDateAlignment for details.}

\item{\code{CarryIndicator}}{A DSTimeSeriesCarryIndicator enum value specifying how to treat 'Not A Number' values for non-trading days
and how to represent values if users request data after the end of the timeseries range. See DSTimeSeriesCarryIndicator for details.}

\item{\code{PrimeCurrencyCode}}{An optional 2 character currency code for your timeseries.}

\item{\code{HasPadding}}{This property has been replaced with the CarryIndicator property and will always be False}

\item{\code{UnderCurrencyCode}}{This property has been deprecated and will always return NULL}

\item{\code{AsPercentage}}{This This property has been deprecated and will always return False}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DSTimeSeriesUserObjectBase-new}{\code{DSTimeSeriesUserObjectBase$new()}}
\item \href{#method-DSTimeSeriesUserObjectBase-clone}{\code{DSTimeSeriesUserObjectBase$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSUserObjectBase" data-id="SetSafeUpdateParams"><a href='../../DatastreamR/html/DSUserObjectBase.html#method-DSUserObjectBase-SetSafeUpdateParams'><code>DatastreamR::DSUserObjectBase$SetSafeUpdateParams()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSTimeSeriesUserObjectBase-new"></a>}}
\if{latex}{\out{\hypertarget{method-DSTimeSeriesUserObjectBase-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSTimeSeriesUserObjectBase$new(jsonDict)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jsonDict}}{JSON dictionary (from JSON Response)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSTimeSeriesUserObjectBase object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSTimeSeriesUserObjectBase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DSTimeSeriesUserObjectBase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSTimeSeriesUserObjectBase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
