% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate}
\alias{estimate}
\title{Fit a specified CDE estimator}
\usage{
estimate(
  object,
  formula,
  data,
  subset,
  crossfit = TRUE,
  n_folds,
  n_splits = 1L
)
}
\arguments{
\item{object}{A \code{cde_estimator} object that has already been passed
to at least one call to \code{set_treatment}.}

\item{formula}{A formula object with describing the outcome of
interest on the left-hand side and the treatment variables the user
wants to estimate effects for (which might be a subset of the
treatment variables specified).}

\item{data}{A \code{data.frame} containing all variables, including
treatment variables and covariates specified.}

\item{subset}{Anan optional vector specifying a subset of
observations to be used in the fitting process.}

\item{crossfit}{A logical indicator for if cross-fitting should be
used in estimating the effects.}

\item{n_folds}{The number of folds to use within a given instance
of the cross-fitting algorithm.}

\item{n_splits}{The number of times the cross-fitting procedure
should be repeated. Overall estimates use the median value of these
repeated estimates.}
}
\description{
Fit a CDE estimator with the engines specified in the \code{model_spec}
object.
}
