% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcDissim.R
\name{findMax}
\alias{findMax}
\title{Calculate Distance  Between given Attribute Values by considering only a pair of attributes.}
\usage{
findMax(Ai, Aj, x, y)
}
\arguments{
\item{Ai}{A list consisting values of a selected attribute}

\item{Aj}{A list consisting values of another selected attribute}

\item{x}{Value from Ai}

\item{y}{Another value from Ai}
}
\value{
distance between x and y for Aj with respect to Ai.
}
\description{
Takes in two lists Ai and Aj, representing values of two attributes, two values x and y from Ai.
Quantitative attributes are accepted only after descretization. Calculates distance between x and y
for Aj with respect to Ai.
}
\details{
findMax is the implementation of find_max() function proposed by Ahmad & Dey (2007).
See Ahmad & Dey (2007) for more datails.
}
\examples{
Attrib_i <- c("A","B","A","C")
Attrib_j <- c("Q","Q","R","Q")
xVal <- "A"
yVal <- "B"
QualiVars <- data.frame(Qlvar1 = c("A","B","A","C"), Qlvar2 = c("Q","Q","R","Q"))
library(dplyr)
distBetXY <- findMax(Attrib_i,Attrib_j,xVal,yVal)
}
\references{
Ahmad, A., & Dey, L. (2007). A k-mean clustering algorithm for mixed numeric and categorical data. Data & Knowledge Engineering, 63(2), 503-527.
}

