\name{FitSingleMod}
\alias{FitSingleMod}
\alias{print.FitSingleMod}
\alias{summary.FitSingleMod}
\alias{print.summary.FitSingleMod}
\alias{plot.FitSingleMod}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{
FitSingleMod
}
\description{
Function to fit a model to the diversity values of subsamples of a given sample and its nested samples.
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
FitSingleMod(model.list, init.param, param.range,
             main.samp, tot.pop=(100*(DivSampleNum(main.samp,2)[1])),
             numit=10^5, varleft=1e-8, data.default=TRUE,
             subsizes = 6, dssamps = list(), nrf = 1,
             minrarefac=1, NResamples=1000, minplaus=10,
             fitloops=2)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{model.list}{
  model; written as a function: function(x, params) with(as.list(params), FunctionOfParams). Examples are given in the ModelSet data file as part of the DivE package. Used in the modFit function.
}
  \item{init.param}{
  matrix of of initial seed model parameters. For each matrix, each row represents a given parameter set; each column represents a parameter value. Column names must match parameter names (params) in the corresponding model in the list \code{models}. Examples are given in the ParamSeeds data file as part of the DivE package.
}
  \item{param.range}{
  matrix of lower and upper model parameters bounds. Used for the modFit function. The first and second row corresponds to the lower and upper bounds respectively; each column represents a parameter value. Column names must match parameter names (params) in the corresponding model in the list \code{models}. Examples are given in the ParamRanges data file as part of the DivE package.
}
  \item{main.samp}{
  the main sample, either as a 2-column data.frame (species ID, count of species), or a vector of species IDs.
}
  \item{tot.pop}{
  total population (integer); default set to 100x the \code{main.samp} size.
}
  \item{numit}{
  control argument passed to optimisation routine; the maximum number of iterations that modFit will perform. See \code{\link[FME]{modFit}} for details.
}
  \item{varleft}{
  control argument passed to optimisation routine; see \code{\link[FME]{modFit}} for details.
}
  \item{data.default}{
  if \code{True}, then the list of vectors of nested rarefaction data (divsubsample objects) generated by the \emph{DivSampleNum} and \emph{divsubsample} functions; if \code{False}, then the function uses the user-specified list of nested rarefaction data, \emph{dssamps}
}
  \item{subsizes}{
  either number of subsamples of main.samp (integer), or a vector of subsample lengths. If the former, then the vector of sample lengths will be created using the \emph{DivSampleNum} function.

}
  \item{dssamps}{
  list of user specified rarefaction data \emph{DivSubsamples} objects. The length of each component vector of each object in the list must correspond to the vector of subsample lengths (as defined by the user in \code{subsizes}).
}
  \item{nrf}{
  difference between lengths of successive rarefaction datapoints.
}
  \item{minrarefac}{
  minimum rarefaction x-axis value. This argument is not used if list of \emph{DivSubsamples} object is specified in \emph{dssamps}.
}
  \item{NResamples}{
  number of resamples used to calculate the rarefaction data. This parameter is not used if list of \emph{DivSubsamples} object is specified in \code{dssamps}. NB: different from \code{numit} parameter, which is specific to the fitting process.
}
  \item{minplaus}{
  lower x-axis bound for plausibility check.
}
  \item{fitloops}{
  number of fitting rounds performed for each model. In each round of fitting, the initial seed parameter values for each model will be the fitted parameters of the previous fitting run. This parameter has a significant impact on the computational time. The `sweet spot' is 2.
}
}
\details{
This function fits a single specified model to the diversity values of the subsamples of a set of nested samples. The output is a list of raw fitting results (pre-scoring). The user should use this function if he or she is interested in fitting a specific parametric rarefraction curve to a sample (rather than selecting the most appropriate model) and examining its performance.
}
\value{
A list of class \emph{FitSingleMod} containing the results of the fit of the model to the diversity samples. This includes the following:

  \item{param }{matrix of fitted parameters for each nested sample}
  \item{ssr }{sum-of-squared residuals for the fits for each nested sample}
  \item{ms }{mean sum-of-squared residuals for the fits for each nested sample}
  \item{discrep }{goodness-of-fit values for the fits for each nested sample; this expressed as the average across the subsamples in each nested sample of all the percentage residuals}
  \item{local }{prediction of main sample sizes according to fitted curves for each of the nested samples}
  \item{global }{prediction of population diversity at \code{popsize} according to fitted curves for each of the nested subsamples}
  \item{AccuracyToObserved }{vector of percentage errors between the observed diversity of full sample data and the estimated diversity of full sample data from subsamples}
  \item{subsamplesizes }{vector of nested subsample sizes}
  \item{datapoints }{the list of \emph{divsubsample} objects used in the fitting. The length of the list is equal to number of samples}
  \item{modelname }{name of the model used}
  \item{numparam }{number of parameters in the model}
  \item{sampvar }{the mean squared distances between subsample curves, local and global}
  \item{mono.local }{matrix of logical values: is the curve monotonically increasing, up to the main sample size?}
  \item{mono.global }{matrix of logical values: is the curve monotonically increasing, up to the population size?}
  \item{slowing.local }{matrix of logical values: is the rate of increase in the curve slowing (decreasing second derivative), up to the main sample size?}
  \item{slowing.global }{matrix of logical values: is the rate of increase in the curve slowing (decreasing second derivative), from \code{minplaus} to the population size (\code{popsize}?}
  \item{plausibility }{matrix of logical values: is the curve plausible (i.e. monotonically increasing and with decreasing second derivative)?}
  \item{dist.local }{matrix of distances between curves fitted to the nested samples. Distances are calculated as areas between curves bounded by 0 and the main sample size}
  \item{dist.global }{similar to \emph{dist.local}, but with curve upper bound the population size}
  \item{local.ref.dist }{distances of nested curves to the curve fitted to the whole sample, with the curves bounded by 0 and the main sample size}
  \item{global.ref.dist }{similar to \emph{local.ref.dist} but with curve upper bound the population size}
  \item{popsize }{user defined population size}
  \item{the model }{the function corresponding to the user-selected \code{modelname}}
}
\references{
Laydon, D. J., Melamed, A., Sim, A., Gillet, N. A., Sim, K., Darko, S., Kroll, S., Douek, D. C., Price, D., Bangham, C. R. M., Asquith, B., Quantification of HTLV-1 clonality and TCR diversity, PLOS Comput. Biol. 2014
}
\author{
Daniel J. Laydon, Aaron Sim, Charles R.M. Bangham, Becca Asquith
%%  ~~who you are~~
}


\seealso{
\code{\link[DivE]{ScoreSingleMod}}
}
\examples{
# See documentation of \code{ScoreSingleMod} for examples
}

\keyword{ diversity }


