% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FrechetESPlot2DCl.R
\name{FrechetESPlot2DCl}
\alias{FrechetESPlot2DCl}
\title{Plots Frechet Expected Shortfall against confidence level}
\usage{
FrechetESPlot2DCl(mu, sigma, tail.index, n, cl, hp)
}
\arguments{
\item{mu}{Location parameter for daily L/P}

\item{sigma}{Scale parameter for daily L/P}

\item{tail.index}{Tail index}

\item{n}{Block size from which maxima are drawn}

\item{cl}{Confidence level and should be a vector}

\item{hp}{Holding period}
}
\description{
Plots the ES of a portfolio against confidence level assuming extreme losses
are Frechet distributed, for specified confidence level and a given
holding period.
}
\details{
Note that the long-right-hand tail is fitted to losses, not profits.
}
\examples{
# Plots ES against vector of cl assuming Frechet Distribution for given parameters
   cl <- seq(0.9,0.99,0.01)
   FrechetESPlot2DCl(3.5, 2.3, 1.6, 10, cl, 30)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Embrechts, P., Kluppelberg, C. and Mikosch, T., Modelling Extremal Events for
Insurance and Finance. Springer, Berlin, 1997, p. 324.

Reiss, R. D. and Thomas, M. Statistical Analysis of Extreme Values from
Insurance, Finance, Hydrology and Other Fields, Birkhaueser, Basel, 1997,
15-18.
}

