% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utteranceStatistics.R
\name{utteranceStatistics}
\alias{utteranceStatistics}
\title{Utterance Statistics}
\usage{
utteranceStatistics(drama, normalizeByDramaLength = TRUE)
}
\arguments{
\item{drama}{The dramatic text(s)}

\item{normalizeByDramaLength}{Logical value. If true, the resulting values will be normalized by the length of the drama.}
}
\value{
Returns an object of class \code{QDUtteranceStatistics}, 
which is essentially a data.frame.
}
\description{
This method calculates the length of each utterance, organized by 
character and drama.
}
\examples{
data(rksp.0)
ustat <- utteranceStatistics(rksp.0)
\donttest{
boxplot(ustat$utteranceLength ~ ustat$character,
   col=qd.colors[1:5],
   las=2, frame=FALSE)
}
}
\seealso{
\code{\link{characterNames}}
}
