% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.dynforest}
\alias{print.dynforest}
\alias{print.dynforestvimp}
\alias{print.dynforestgvimp}
\alias{print.dynforestvardepth}
\alias{print.dynforestoob}
\alias{print.dynforestpred}
\title{Print function}
\usage{
\method{print}{dynforest}(x, ...)

\method{print}{dynforestvimp}(x, ...)

\method{print}{dynforestgvimp}(x, ...)

\method{print}{dynforestvardepth}(x, ...)

\method{print}{dynforestoob}(x, ...)

\method{print}{dynforestpred}(x, ...)
}
\arguments{
\item{x}{Object inheriting from classes \code{dynforest}, \code{dynforestvimp} or \code{dynforestgvimp}.}

\item{...}{Optional parameters to be passed to the low level function}
}
\description{
This function displays a brief summary regarding the trees (for class \code{dynforest}), a data frame with variable importance (for class \code{dynforestvimp}) or the grouped variable importance (for class \code{dynforestgvimp}).
}
\examples{
\donttest{
data(pbc2)

# Get Gaussian distribution for longitudinal predictors
pbc2$serBilir <- log(pbc2$serBilir)
pbc2$SGOT <- log(pbc2$SGOT)
pbc2$albumin <- log(pbc2$albumin)
pbc2$alkaline <- log(pbc2$alkaline)

# Sample 100 subjects
set.seed(1234)
id <- unique(pbc2$id)
id_sample <- sample(id, 100)
id_row <- which(pbc2$id\%in\%id_sample)

pbc2_train <- pbc2[id_row,]

timeData_train <- pbc2_train[,c("id","time",
                                "serBilir","SGOT",
                                "albumin","alkaline")]

# Create object with longitudinal association for each predictor
timeVarModel <- list(serBilir = list(fixed = serBilir ~ time,
                                     random = ~ time),
                     SGOT = list(fixed = SGOT ~ time + I(time^2),
                                 random = ~ time + I(time^2)),
                     albumin = list(fixed = albumin ~ time,
                                    random = ~ time),
                     alkaline = list(fixed = alkaline ~ time,
                                     random = ~ time))

# Build fixed data
fixedData_train <- unique(pbc2_train[,c("id","age","drug","sex")])

# Build outcome data
Y <- list(type = "surv",
          Y = unique(pbc2_train[,c("id","years","event")]))

# Run dynforest function
res_dyn <- dynforest(timeData = timeData_train, fixedData = fixedData_train,
                     timeVar = "time", idVar = "id",
                     timeVarModel = timeVarModel, Y = Y,
                     ntree = 50, nodesize = 5, minsplit = 5,
                     cause = 2, ncores = 2, seed = 1234)

# Print function
print(res_dyn)

# Compute VIMP statistic
res_dyn_VIMP <- compute_vimp(dynforest_obj = res_dyn, ncores = 2, seed = 1234)

# Print function
print(res_dyn_VIMP)

# Compute gVIMP statistic
res_dyn_gVIMP <- compute_gvimp(dynforest_obj = res_dyn,
                               group = list(group1 = c("serBilir","SGOT"),
                                            group2 = c("albumin","alkaline")),
                               ncores = 2, seed = 1234)

# Print function
print(res_dyn_gVIMP)

# Run var_depth function
res_varDepth <- compute_vardepth(res_dyn)

# Print function
print(res_varDepth)

}

}
\seealso{
\code{\link[=dynforest]{dynforest()}} \code{\link[=compute_ooberror]{compute_ooberror()}} \code{\link[=compute_vimp]{compute_vimp()}} \code{\link[=compute_gvimp]{compute_gvimp()}} \code{\link[=compute_vardepth]{compute_vardepth()}} \code{\link[=predict.dynforest]{predict.dynforest()}}
}
