% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_entity_resource_metadata.R
\name{read_data_entity_resource_metadata}
\alias{read_data_entity_resource_metadata}
\title{Read data entity resource metadata}
\usage{
read_data_entity_resource_metadata(
  packageId,
  entityId,
  as = "data.frame",
  env = "production"
)
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{entityId}{(character) Data entity identifier}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) The resource metadata of 
\code{entityId} in \code{packageId}
}
\description{
Read data entity resource metadata
}
\examples{
\dontrun{

# List entities
entityIds <- list_data_entities(packageId = "knb-lter-cce.310.1")
head(entityIds)
#> [1] "4aaaff61e0d316130be0b445d3013877"
#> [2] "088775341e7fb65206af8c9e67d076e2"
#> [3] "6982dd80cba66470c49a2f3dc0f82459"
#> [4] "782fbaa20ea62987c838378e9eadcfa6"
#> [5] "ae8ecd148df1275b30358577d0fa6b4a"
#> [6] "a53b312efe0a176fdfc74ab7ccb0916b"

# Read resource metadata for first entity
resourceMetadata <- read_data_entity_resource_metadata(
 packageId = "knb-lter-cce.310.1",
 entityId = entityIds[1]
)
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_package}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
