% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glla.R
\name{glla}
\alias{glla}
\title{Generalized Local Linear Approximation}
\usage{
glla(
  x,
  n.embed,
  tau,
  delta,
  order,
  na.derivative = c("none", "kalman", "rowwise", "skipover")
)
}
\arguments{
\item{x}{Numeric vector.
An observed time series}

\item{n.embed}{Numeric (length = 1).
Number of embedded dimensions (the number of observations
to be used in the \code{\link[EGAnet]{Embed}} function)}

\item{tau}{Numeric (length = 1).
Number of observations to offset successive embeddings in
the \code{\link[EGAnet]{Embed}} function. A \code{tau} of one
uses adjacent observations.
Default is \code{1}}

\item{delta}{Numeric (length = 1).
The time between successive observations in the time series.
Default is \code{1}}

\item{order}{Numeric (length = 1).
The maximum order of the derivative to be estimated. For example,
\code{"order = 2"} will return a matrix with three columns with the estimates
of the observed scores and the first and second derivative for each row of the embedded
matrix (i.e. the reorganization of the time series implemented via
the \code{\link[EGAnet]{Embed}} function)}

\item{na.derivative}{Character (length = 1).
How should missing data in the embeddings be handled?
Available options (see Boker et al. (2018) for more details):

\itemize{

\item \code{"none"} (default) --- does nothing and leaves \code{NA}s in data

\item \code{"kalman"} --- uses Kalman smoothing (\code{\link[stats]{KalmanSmooth}}) with
structural time series models (\code{\link[stats]{StructTS}}) to impute missing values.
This approach models the underlying temporal dependencies (trend, seasonality, autocorrelation)
to generate estimates for missing observations while preserving the original time scale.
More computationally intensive than the other methods but typically provides the
most accurate imputation by respecting the stochastic properties of the time series

\item \code{"rowwise"} --- adjusts time interval with respect to each embedding ensuring
time intervals are adaptive to the missing data (tends to be more accurate than \code{"none"})

\item \code{"skipover"} --- "skips over" missing data and treats the non-missing points
as continuous points in time (note that the time scale shifts to the "per mean time interval,"
which is different and \emph{larger} than the original scale)

}}
}
\value{
Returns a matrix containing \emph{n} columns in which \emph{n}
is one plus the maximum order of the derivatives to be estimated via
generalized local linear approximation
}
\description{
Estimates the derivatives of a time series using generalized
local linear approximation (GLLA). GLLA is a filtering method for
estimating derivatives from data that uses time delay embedding and a
variant of Savitzky-Golay filtering to accomplish the task.
}
\examples{
# A time series with 8 time points
tseries <- 49:56
deriv.tseries <- glla(tseries, n.embed = 4, tau = 1, delta = 1, order = 2)

}
\references{
\strong{GLLA implementation} \cr
Boker, S. M., Deboeck, P. R., Edler, C., & Keel, P. K. (2010)
Generalized local linear approximation of derivatives from time series. In S.-M. Chow, E. Ferrer, & F. Hsieh (Eds.),
\emph{The Notre Dame series on quantitative methodology. Statistical methods for modeling human dynamics: An interdisciplinary dialogue},
(p. 161-178). \emph{Routledge/Taylor & Francis Group}.

Deboeck, P. R., Montpetit, M. A., Bergeman, C. S., & Boker, S. M. (2009)
Using derivative estimates to describe intraindividual variability at multiple time scales.
\emph{Psychological Methods}, \emph{14(4)}, 367-386.

\strong{Filtering procedure} \cr
Savitzky, A., & Golay, M. J. (1964).
Smoothing and differentiation of data by simplified least squares procedures.
\emph{Analytical Chemistry}, \emph{36(8)}, 1627-1639.

\strong{Missing Data} \cr
Boker, S. M., Tiberio, S. S., & Moulder, R. G. (2018).
Robustness of time delay embedding to sampling interval misspecification.
In K. van Montfort, J. H. L. Oud, & M. C. Voelkle (Eds.),
\emph{Continuous Time Modeling in the Behavioral and Related Sciences} (pp. 239–258).
Springer International Publishing.
}
\author{
Hudson Golino <hfg9s at virginia.edu>
}
