% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualsMCR.R
\name{residuals.MCR}
\alias{residuals.MCR}
\title{Compute residuals for MCR model}
\usage{
\method{residuals}{MCR}(object, type = c("cox-snell", "quantile"), ...)
}
\arguments{
\item{object}{An object of class \code{MCR}, typically returned from \code{\link{MCRfit}}.}

\item{type}{Type of residual.}

\item{...}{Additional arguments (not used).}
}
\value{
A numeric vector of residuals.
}
\description{
This function computes Global Cox-Snell and randomized quantile residuals for objects of class \code{MCR}.
}
\examples{
data(liver)
names(liver)

model <- MCRfit(
 survival::Surv(time, status) ~ age + medh + relapse + grade | sex + age + medh + grade,
 data = liver
)
summary(residuals(model,type="quantile"))

}
