% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_responsibleParty.R
\name{set_responsibleParty}
\alias{set_responsibleParty}
\title{set_responsibleParty}
\usage{
set_responsibleParty(
  givenName = NULL,
  surName = NULL,
  organizationName = NULL,
  positionName = NULL,
  address = NULL,
  phone = NULL,
  electronicMailAddress = NULL,
  onlineUrl = NULL,
  userId = NULL,
  id = NULL,
  email = NULL
)
}
\arguments{
\item{givenName}{individual's given names (list or vector for multiple names).  OR a person object.}

\item{surName}{individual name}

\item{organizationName}{if party is an organization instead of an individual, name for the org}

\item{positionName}{individual's position, i.e. "Researcher", "Graduate Student", "Professor"}

\item{address}{address object, see `eml$address` to build an address object}

\item{phone}{individual or organization phone number}

\item{electronicMailAddress}{email address (alternatively, can use 'email' argument)}

\item{onlineUrl}{a URL to the homepage of the individual or organization}

\item{userId}{the user's ID, usually within a particular system (KNB, DataONE)}

\item{id}{Identifier for this block, ideally an ORCID id (optional)}

\item{email}{alias for electronicMailAddress}
}
\value{
A emld object for any responsibleParty (e.g. creator, contact, etc)
}
\description{
set_responsibleParty
}
\examples{
# Pass in either a person object or separate values to create an individual
carl <- set_responsibleParty(as.person("Carl Boettiger <cboettig@ropensci.org>"))
matt <- set_responsibleParty("Matthew", "Jones", email = "mbjones@nceas.ucsb.edu")

# To create an organization, use the named `organization` argument to
# specify the organization name
my_org <- set_responsibleParty(
  organization = "My Organization",
  email = "contact@example.org"
)
}
