% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSS.R
\docType{data}
\name{Smoke}
\alias{Smoke}
\title{Survey Data on Smoking Behaviour}
\format{
a dataframe with 807 observations and 8 variables as below:
\describe{
\item{educ}{years of schooling (numeric)}
\item{age}{age of respondents (numeric)}
\item{cigpric}{cigarette price(state), cents per pack (numeric)}
\item{income}{annual income in us dollar (numeric)}
\item{restaurn}{state smoking restrictions for restaurants exist or not (categorical)}
\item{smoker}{smoked at least once or not (categorical)}
\item{cigs_intervals}{number of cigarettes smoked per day, with interval boundaries: 0,5,10,20,50 (numeric)}
\item{cigs}{number of cigarettes smoked per day (numeric)}
}
}
\source{
Wooldridge's dataset is available on \url{https://ideas.repec.org/p/boc/bocins/smoke.html#biblio}.
}
\usage{
data(Smoke, package = "EMSS")
}
\description{
The Data is the subset of the original data from Mullahy (1985) and Mullahy (1997). The dataset is from
Wooldridge (2009) used for researches on cross sectinal data studies.
The dataset is also available from \code{\link[sampleSelection]{Smoke}} from the package \code{sampleSelection}.
}
\references{
Jeffrey, M. Wooldridge (2009) \emph{Introductory Econometrics: A modern approach}, Canada: South-Western Cengage Learning.

Mullahy, John (1985) \emph{Cigarette Smoking: Habits, Health Concerns, and Heterogeneous Unobservables in a Microeconometric Analysis of Consumer Demand},
Ph.D. dissertation, University of Virginia.

Mullahy, John (1997), Instrumental-Variable Estimation of Count Data Models: Applications to Models of Cigarette Smoking Behavior,
\emph{Review of Economics and Statistics}, 79, 596-593.
}
\keyword{datasets}
