% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{smth}
\alias{smth}
\alias{smth,binClst-method}
\alias{smth,binClstStck-method}
\title{Posterior smoothing of single local labels.}
\usage{
smth(obj, dlta = 1)

\S4method{smth}{binClst}(obj, dlta = 1)

\S4method{smth}{binClstStck}(obj, dlta = 1)
}
\arguments{
\item{obj}{Either a \code{binClst_instance} or a \code{binClstStck_instance}.}

\item{dlta}{A numeric value in the range (0,1) (default is 1) indicating the
user's will to accept a change of label. The change of label is done
whenever the decrease in likelihood is not greater then \code{dlta}.}
}
\value{
A smoothed copy of the input instance. In the case of a
  \code{binClstStck_instance} smoothing is performed at population level
  as well as at each individual trajectory in the stack.
}
\description{
\code{smth} Performs a posterior smoothing of single local
  labels (locations that differ from their neighbouring locations while the
  later have equal labels).
}
\examples{
# -- cluster the example path with a prior smooth of 1 hour --
mysmoothbcp <- stbc(expth,smth=1,info=-1)
# -- apply a posterior smoothing --
mysmoothbcpsmoothed <- smth(mysmoothbcp,dlta=0.5)
}
