% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isoforms.R
\name{ImportIsoformQuant}
\alias{ImportIsoformQuant}
\title{Import transcript isoform quantification into EZbakRData object}
\usage{
ImportIsoformQuant(
  obj,
  files,
  quant_tool = c("none", "salmon", "sailfish", "alevin", "piscem", "kallisto", "rsem",
    "stringtie"),
  txIn = TRUE,
  ...
)
}
\arguments{
\item{obj}{An \code{EZbakRData} object.}

\item{files}{A named vector of paths to all transcript quantification files that you would like
to import. This will be passed as the first argument of \code{tximport::tximport()} (also named \code{files}).
The names of this vector should be the same as the sample names as they appear in the
metadf of the \code{EZbakRData} object.}

\item{quant_tool}{String denoting the type of software used to generate the abundances. Will
get passed to the \code{type} argument of \code{tximport::tximport()}. As described in the documentation for
\code{tximport} 'Options are "salmon", "sailfish", "alevin", "piscem", "kallisto", "rsem", "stringtie",
or "none". This argument is used to autofill the arguments below (geneIdCol, etc.) "none" means
that the user will specify these columns. Be aware that specifying type other than "none" will
ignore the arguments below (geneIdCol, etc.)'. Referenced 'arguments below' can be specified
as part of \code{...}.}

\item{txIn}{Whether or now you are providing isoform level quantification files.
Alternative (\code{txIn = FALSE}) is gene-level quantification. In \code{ImportIsoformQuant},
\code{txIn} gets passed to BOTH the \code{txIn} and \code{txOut} parameters in \code{tximport()}.}

\item{...}{Additional arguments to be passed to \code{tximport::tximport()}. Especially relevant if
you set \code{quant_tool} to "none".}
}
\value{
An \code{EZbakRData} object with an additional element in the \code{readcounts}
list named "isform_quant_<quant_tool>". It contains TPM, expected_count,
and effective length information for each transcript_id and each sample.
}
\description{
A convenient wrapper to \href{https://bioconductor.org/packages/release/bioc/vignettes/tximport/inst/doc/tximport.html}{\code{tximport()}} for importing isoform quantification
data into an EZbakRData object. You need to run this before running
\code{EstimateIsoformFractions}.
}
\examples{

# Dependencies for example
library(dplyr)
library(data.table)

# Simulate and analyze data
simdata <- EZSimulate(30)
ezbdo <- EZbakRData(simdata$cB, simdata$metadf)
ezbdo <- EstimateFractions(ezbdo)

# Hack to generate example quantification files
savedir <- tempdir()
rsem_data <- tibble(
  transcript_id = paste0("tscript_feature", 1:30),
  gene_id = paste0("feature", 1:30),
  length = 1000,
  effective_length = 1000,
  expected_count = 1000,
  TPM = 10,
  FPKM = 10,
  IsoPct = 1
)

fwrite(rsem_data, file.path(savedir, "Sample_1.isoforms.results"), sep = '\t')

files <- file.path(savedir,"Sample_1.isoforms.results")
names(files) <- "Sample_1"

# Read in file
ezbdo <- ImportIsoformQuant(ezbdo, files, quant_tool = "rsem")



}
