% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{setGenome}
\alias{setGenome}
\title{Setting the genome}
\usage{
setGenome(listHapLoci = list(), listDipLoci = list(), recRate = numeric())
}
\arguments{
\item{listHapLoci}{a list of haploid loci}

\item{listDipLoci}{a list of diploid loci}

\item{recRate}{a two-by-two recombination rate vector}
}
\value{
a \code{Genome} object
}
\description{
Generation of a genome class object from the list of haploid loci
and diploid loci. Each loci is defined by a factor vector that enumerates
its alleles.
}
\details{
A genome includes the list of all possible haplotypes and genotypes
resulting from the combination of the alleles defined in input.
As the \code{Ease} package was originally built for population genetics
simulations including both diploid and haploid loci, it is necessary
that both types of loci are defined. Despite this, the user can define
only diploid or only haploid loci if they wish. If no diploid locus is
defined, one is automatically generated with only one allele, thus not
influencing the simulation. The same applies if no haploid locus is defined.

Each locus is described by a vector of factors which are the names of
the possible alleles at that locus. All diploid (resp. haploid) loci
thus defined are grouped in a list, called \code{listDipLoci} (resp.
\code{listHapLoci}). Therefore, a \code{Genome} class object has two lists
of loci defined in this way, one for diploid loci, one for haploid loci.
The alleles and loci (diploid and haploid) must all have different
names so that no ambiguity can persist.

If several are defined, the order of the diploid loci in the list is not
trivial. The rates of two-to-one combinations between them must indeed be
defined by the vector \code{recRate}. For example, if three diploid loci
are defined, \code{recRate} must be of length 2, the first of its values
defining the recombination rate between the first and second loci, the
second of its values the recombination rate between the second and third
loci. For example, if we want to define two groups of two loci that are
linked to each other but are on two different chromosomes, we can define
a \code{recRate = c(0.1, 0.5, 0.1)}. The first two loci are thus relatively
linked (recombination rate of 0.1), as are the last two loci. On the other
hand, the recombination rate of 0.5 between the second and third loci
ensures that the two groups are independent.
}
\examples{
DL <- list(dl = c("A", "a"))
HL <- list(hl = c("B", "b"))
genomeObj <- setGenome(listHapLoci = HL, listDipLoci = DL)

}
\author{
Ehouarn Le Faou
}
