% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bglmar1.R
\name{bglmar1}
\alias{bglmar1}
\title{Bayesian Generalized Linear Model with AR(1) Errors}
\usage{
bglmar1(
  data_path,
  circ_vars,
  prod_vars,
  max_lag = 3,
  initial_frac = 0.7,
  initial_min = 90,
  test_h = 12,
  step_h = 12,
  lfo_window = "sliding",
  chains = 4,
  parallel_chains = 4,
  iter = 1500,
  warmup = 750,
  adapt_delta = 0.95,
  trees = 12,
  seed = 2025,
  support_min = 0.6,
  folds_min = 5,
  sup_hi = 0.7,
  sup_lo = 0.6,
  backend = c("auto", "rstan", "cmdstanr")
)
}
\arguments{
\item{data_path}{Path to Excel file containing the data}

\item{circ_vars}{Character vector of circulation variable names}

\item{prod_vars}{Character vector of production variable names}

\item{max_lag}{Maximum number of lags for independent variables (default: 3)}

\item{initial_frac}{Initial fraction of data for training (default: 0.7)}

\item{initial_min}{Minimum number of observations for initial training (default: 90)}

\item{test_h}{Test horizon in months (default: 12)}

\item{step_h}{Step size between folds in months (default: 12)}

\item{lfo_window}{Type of window for LFO ("sliding" or "expanding", default: "sliding")}

\item{chains}{Number of MCMC chains (default: 4)}

\item{parallel_chains}{Number of parallel chains (default: 4)}

\item{iter}{Total iterations per chain (default: 1500)}

\item{warmup}{Warmup iterations per chain (default: 750)}

\item{adapt_delta}{Adapt delta parameter for NUTS (default: 0.95)}

\item{trees}{Maximum tree depth for NUTS (default: 12)}

\item{seed}{Random seed (default: 2025)}

\item{support_min}{Minimum support threshold for stable relationships (default: 0.6)}

\item{folds_min}{Minimum number of folds required (default: 5)}

\item{sup_hi}{High support threshold (default: 0.7)}

\item{sup_lo}{Low support threshold (default: 0.6)}

\item{backend}{Backend for Stan compilation: "auto" (default), "rstan", or "cmdstanr".
If "auto", the function uses 'rstan' when available, otherwise tries 'cmdstanr'.}
}
\value{
A list containing:
\item{bench_bayes}{Full results for all pairs}
\item{winners_070}{Pairs with support >= 0.70}
\item{winners_060}{Pairs with support >= 0.60}
\item{rank_out}{Output from ranking function}
}
\description{
Implements a Bayesian GLM with autoregressive errors of order 1 for causal inference
between economic variables, with emphasis on temporal stability through Leave-Future-Out
cross-validation.
}
\details{
This function implements a Bayesian GLM with AR(1) errors for assessing causal relationships
between economic variables. It uses Leave-Future-Out cross-validation with sliding windows
to evaluate temporal stability of relationships. The function no longer requires 'cmdstanr'
at install time; if 'backend = "cmdstanr"' is requested but 'cmdstanr' (and a working CmdStan)
are not available, it gracefully falls back to 'rstan'. In any case, heavy computations are
not run in package examples or tests.
}
\examples{
\dontrun{
# Example usage
result <- bglmar1(
  data_path = file.path(tempdir(), "data.xlsx"),
  circ_vars = c("TC_SPOT_CAN_US", "TC_SPOT_US_CAN", "TC_SPOT_US_REMB",
                "IPC", "TdI_LdelT", "TasaDescuento"),
  prod_vars = c("ValorExportaciones", "Real_Net_Profit", 
                "RealSocialConsumptionPerWorker2017", "RealWage_PPP2017",
                "CapitalStock_PPP2017", "LaborProductivity_PPP2017", 
                "InvestmentPerWorker_PPP2017"),
  backend = "auto"
)
}

}
