% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Curves_and_Slopes.R
\name{Slope}
\alias{Slope}
\title{Method to calculate the derivative of irregular functions:}
\usage{
Slope(ecotonefinder, method = c("dca", "fanny", "vegclust", "cmeans",
  "diversity", "all"), window = 3, axis.number = 1,
  groups = ecotonefinder$groups, diversity = c("shannon", "richness",
  "expShannon", "pielou", "all"))
}
\arguments{
\item{ecotonefinder}{A list containing elements named in the same way than
EcotoneFinder function outcomes}

\item{method}{The name of the method for which the slopes should be
calculated. Correspond to the names of the list.}

\item{window}{Must be an odd number. The interval to be used for slope
calculation. The bigger the window, the more averaged the slope will be.}

\item{axis.number}{If "dca" is chosen, indicate the number of axis over which
to calculate the slope (first axis, first and second axis,...)}

\item{groups}{If any clustering method is chosen, corresponds to the index of
the cluster for which the slope shold be calculated. If "all", the slope
will be calculated for all the clusters.}

\item{diversity}{If "diversity" is chosen in the method argument, define the
diversity index for which to calculate the slope. "all" can be chosen.}
}
\value{
A list of dataframes containing the slope values for the specified
 methods and the original data.
}
\description{
Method to calculate the derivative of irregular functions:
}
\details{
Slope calculations are done by moving window analysis. The width of
 the windows is defined by the window argument. For each window, the result
 of slope coefficient of a linear model (lm function of the stat package) is
 stored and used to draw the general slope along the gradient. The bigger the
 window, the more points will be used to compute the linear models, meaning
 the obtained slopes will be smoother. This also results in the addition of
 NAs at the ends of the gradient.

 The first axis of DCA has been used as a beta-diversity index, and its
 derivative as a method to locate ecotones (see Brownstein et al., 2013). The
 Slope function provide the possibility of computing the slope of the other
 axis, to avoid the loss of information induced by the reduction of the
 dimentionality of the original data. Similarly, the slopes of the fuzzy
 clusters can be used to pinpoint the transitions between them. The value of
 the slopes can be an indicator of the relative sharpness of the transion
 area. Particularly, as the memberships of the fuzzy clusters range betwwen 0
 and 1, these values can readilly be compared between studies and datasets.
 These values vary depending on the window width and can be very sensible to
 noise in the original data. A reliable method to mathematically identify
 breaks is still needed and careful interpretation by the user is still
 required.
}
\examples{
 #### Artificial dataset:
 SyntheticTrial <- SyntheticData(SpeciesNum = 21, CommunityNum = 3,
                                 SpCo = NULL ,Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                   b=c(0,250,500),
                                                   c=rep(0.015,3)),
                                 pal = c("#008585", "#FBF2C4", "#C7522B"))

 ## Analyses:
 SyntheticEcoFinder <- EcotoneFinder(data = SyntheticTrial[,-1],
                                     dist = SyntheticTrial$Distance,
                                     method = "all", groups = 3,
                                     standardize = "hellinger", diversity = "all")

 ## Slope calculation:
 SyntheticSlope <- Slope(SyntheticEcoFinder, method = "all", axis.number = 2,
                         diversity = "all")


}
