% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Curves_and_Slopes.R
\name{curveNoPlot}
\alias{curveNoPlot}
\title{Adaptation of the curve function (without plot).}
\usage{
curveNoPlot(expr, from = NULL, to = NULL, n = 101, add = FALSE,
  type = "l", xname = "x", xlab = xname, ylab = NULL, log = NULL,
  xlim = NULL, ...)
}
\arguments{
\item{expr}{The name of a function, or a call or an expression written as a
function of x which will evaluate to an object of the same length as x.}

\item{from}{the range over which the function will be plotted (start).}

\item{to}{the range over which the function will be plotted (end).}

\item{n}{integer; the number of x values at which to evaluate.}

\item{add}{logical; if TRUE add to an already existing plot; if NA start a
new plot taking the defaults for the limits and log-scaling of the x-axis
from the previous plot. Taken as FALSE (with a warning if a different value
is supplied) if no graphics device is open.}

\item{type}{plot type: see plot.default.}

\item{xname}{character string giving the name to be used for the x axis.}

\item{xlab}{labels and graphical parameters.}

\item{ylab}{labels and graphical parameters.}

\item{log}{labels and graphical parameters. See ‘Details’ for the
interpretation of the default for log.}

\item{xlim}{NULL or a numeric vector of length 2; if non-NULL it provides the
defaults for c(from, to) and, unless add = TRUE, selects the x-limits of
the plot – see plot.window.}

\item{...}{Additional graphical arguments.}
}
\value{
A vector containing the y values of the gaussian along the gradient.
}
\description{
Adaptation of the curve function (without plot).
}
\details{
Silently used by SyntheticData and SyntheticDataSeries. Equivalent
  to the curve function of the graphics package. See the details of the curve
  function in graphics package for more details.
}
\examples{
gaussian <- function(x) a*exp(-(((x-b)^2)/2*(c^2)))
a <- 60
b <- 250
c <- 0.4
Curve=curveNoPlot(gaussian, from = 1, to = 500, n = 500)
Curve$y


}
