% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EcotoneFinder.R
\name{EcotoneFinder}
\alias{EcotoneFinder}
\title{Wraper function to perform ecological gradient analysis}
\usage{
EcotoneFinder(data, dist, method = c("dca", "fanny", "vegclust",
  "diversity", "cmeans", "all"), groups = NULL, m.exp = 2,
  standardize = NULL, seed = 1, diversity = c("shannon", "richness",
  "expShannon", "pielou", "all"), na.rm = FALSE)
}
\arguments{
\item{data}{A dataframe containing species as columns and sites as rows.
May also contain environmental parameters, as long as the parameters are
as columns and the site as rows.}

\item{dist}{A vector or column containing the gradient along which the
analysis will be done. Must be of the same lenght as data.}

\item{method}{One of c("dca", "fanny", "vegclust", "diversity", "cmeans", "all").
Tell the function which analysis to perform. See details.}

\item{groups}{Interger. The desired number of clusters if any of the
clustering method is selected.}

\item{m.exp}{Integer. The membership exponent for any of the clustering
method.}

\item{standardize}{Standardize method to apply to the data before further
analysis (for fanny and cmeans). Must be one of decostand methods (see
decostand).}

\item{seed}{Integer or NULL. Set a seed for initial membership matrix for
cmeans and vegclust algorithms. Recomended for time series, to keep
a more consistent labelling of fuzzy clusters along the gradient.
See Details.}

\item{diversity}{diversity indice to be calculated. See details.}

\item{na.rm}{Logical. Should NAs be removed.}
}
\value{
Ecofinder returns a list containing the original data, the value of
  the main arguments used in the function and the outcome of the selected
  analyses.
}
\description{
Wraper function to perform ecological gradient analysis
}
\details{
EcotoneFinder is a wraper function to perform multiple ecological
  gradient analysis at once. The implemented methods are Detrended
  Correspondance Analysis (DCA) - see Brownstein et al. 2013 - Fuzzy C-Means
  (FCM) - see DeCaceres et al., 2010 - and the calculation of diversity
  indices - see Jost, 2007. The DCA is intenally performed by the decorana
  function of the vegan package. The FCM analyses can be performed by the
  fanny function (cluster package), the vegclust function (vegclust package)
  and the cmeans function (e1071 package) - for comparison purposes as the
  outcome of the analyses might differ.
  The vegclust and cmeans algorithms use random number generators to create
  a matrix of initial centers. Setting a seed with the \emph{seed} argument
  guaranty the reproducibility of the outputs. This argument can also be set
  to NULL, to preserve the randomness of initial centres.

  It is recommended to stadardize data before applying fanny or cmeans
  analysis. See decostand documentation (vegan package) for information on
  standardisation methods. Must be one of:
  "total","max","freq","normalize","range","pa","chi.square","hellinger","log".
  If "log" is chosen, the user will be asked to provide the base to be used
  upon launching the function.

  Several diversity incides have been implemented, as they are supposed to
  react to ecological gradients. It includes the Shannon index, the Pielou
  eveness and species richness - computed with the diversity function of the
  vegan package. expShannon corresponds to the shannon index in terms of
  effective number of species (see Jost, 2007). If "all" is selected, all the
  implemented indices will be calculated.

  If "all" is selected in the method argument, all the implemented methods
  will be applied.
}
\examples{
 #### Artificial dataset:
 SyntheticTrial <- SyntheticData(SpeciesNum = 21, CommunityNum = 3,
                                 SpCo = NULL, Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                   b=c(0,250,500),
                                                   c=rep(0.015,3)),
                                 pal = c("#008585", "#FBF2C4", "#C7522B"))

 ## Analyses:
 SyntheticEcoFinder <- EcotoneFinder(data = SyntheticTrial[,-1],
                                     dist = SyntheticTrial$Distance,
                                     method = "all",
                                     groups = 3, standardize = "hellinger",
                                     diversity = "all")




}
